package ru.yandex.ace.ventura.proxy.suggest;

import java.util.ArrayList;
import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.ace.ventura.proxy.common.AceVenturaContact;
import ru.yandex.http.util.AbstractFilterFutureCallback;

public final class SharedConcatCallback
    extends AbstractFilterFutureCallback<List<List<AceVenturaContact>>, List<AceVenturaContact>>
{
    private final AceVenturaSuggestContext context;

    public SharedConcatCallback(
        final FutureCallback<? super List<AceVenturaContact>> callback,
        final AceVenturaSuggestContext context)
    {
        super(callback);
        this.context = context;
    }

    @Override
    public void completed(final List<List<AceVenturaContact>> response) {
        int size = 0;
        List<AceVenturaContact> result =
            new ArrayList<>(response.size() * context.length());
        for (List<AceVenturaContact> list: response) {
            result.addAll(list);
            size += list.size();
        }

        context.logger().fine("Shared suggest records " + size);
        callback.completed(result);
    }
}
