package ru.yandex.ace.ventura.proxy.suggest;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.ace.ventura.AceVenturaPrefix;
import ru.yandex.ace.ventura.proxy.AceVenturaProxy;
import ru.yandex.ace.ventura.proxy.common.AbstractSharedRule;
import ru.yandex.ace.ventura.proxy.common.AceVenturaContact;
import ru.yandex.http.util.ErrorSuppressingFutureCallback;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.http.util.server.UpstreamStaterFutureCallback;
import ru.yandex.search.rules.pure.SearchRule;
import ru.yandex.search.rules.pure.providers.RequestProvider;

public class SharedSuggestRule<
    T extends RequestProvider & AceVenturaSuggestContextProvider>
    extends AbstractSharedRule<AceVenturaSuggestContext, T, List<AceVenturaContact>>
    implements SearchRule<T, List<AceVenturaContact>>
{
    private final SearchRule<? super AceVenturaSuggestContext, List<AceVenturaContact>> next;

    public SharedSuggestRule(
        final AceVenturaProxy proxy,
        final SearchRule<? super AceVenturaSuggestContext, List<AceVenturaContact>> next)
    {
        super(proxy, Collections.emptyList());
        this.next = next;
    }

    @Override
    protected void execute(
        final AceVenturaSuggestContext context,
        final Map<AceVenturaPrefix, List<Long>> listMap,
        final FutureCallback<? super List<AceVenturaContact>> callback)
        throws HttpException
    {
        MultiFutureCallback<List<AceVenturaContact>> mfcb =
            new MultiFutureCallback<>(new SharedConcatCallback(
                callback,
                context));
        for (Map.Entry<AceVenturaPrefix, List<Long>> entry
            : listMap.entrySet())
        {
            context.logger().fine(
                "Executing shared suggest for "
                    + entry.getKey() + " "
                    + entry.getValue());

            next.execute(
                new ShareSuggestContext(
                    context,
                    entry.getValue(),
                    entry.getKey()),
                new ErrorSuppressingFutureCallback<>(
                    new UpstreamStaterFutureCallback<>(
                        mfcb.newCallback(),
                        proxy.upstreamStater()),
                    Collections.emptyList()));
        }

        mfcb.done();
    }
}
