package ru.yandex.ace.ventura.proxy.suggest;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;

import ru.yandex.ace.ventura.proxy.common.AceVenturaContact;
import ru.yandex.ace.ventura.proxy.common.AceVenturaResultTag;
import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.logger.SearchProxyAccessLoggerConfigDefaults;

public class SuggestResultPrinter
    extends AbstractProxySessionCallback<
    Map.Entry<Collection<AceVenturaContact>, List<AceVenturaResultTag>>>
{
    private final BasicAceVenturaSuggestContext context;
    private final SuggestHandler suggestHandler;

    public SuggestResultPrinter(
        final SuggestHandler suggestHandler,
        final ProxySession session,
        final BasicAceVenturaSuggestContext context)
    {
        super(session);

        this.context = context;
        this.suggestHandler = suggestHandler;
    }

    @Override
    public void completed(
        final Map.Entry<Collection<AceVenturaContact>, List<AceVenturaResultTag>>
            result)
    {
        StringBuilderWriter sbw = new StringBuilderWriter();

        context.session().connection().setSessionInfo(
            SearchProxyAccessLoggerConfigDefaults.HITS_COUNT,
            Long.toString(
                result.getKey().size() + result.getValue().size()));
        StringBuilder sb = new StringBuilder(100);
        sb.append("Found contacts ");
        sb.append(result.getKey().size());
        sb.append(" tags ");
        sb.append(result.getValue().size());

        int contactsPrinted = 0;
        int tagsPrinted = 0;
        context.session().logger().info(sb.toString());
        try (JsonWriter writer = context.jsonType().create(sbw)) {
            writer.startObject();
            writer.key("contacts");
            writer.startArray();
            int i = 0;
            for (AceVenturaContact contact: result.getKey()) {
                if (i >= context.length()) {
                    break;
                }

                if (context.debug()) {
                    context.logger().info(
                        "Info " + contact.emails() + " score "
                            + contact.score() + " ls " + contact.lastUsage()
                            + " dep_size " + contact.corpDepDist()
                            + " source " + contact.user().toString());
                }

                writer.value(contact);
                i += 1;
            }
            contactsPrinted = i;

            writer.endArray();

            writer.key("tags");
            writer.startArray();
            i = 0;
            for (AceVenturaResultTag tag: result.getValue()) {
                if (i >= context.length()) {
                    break;
                }

                writer.value(tag);
                i += 1;
            }
            tagsPrinted = i;
            writer.endArray();

            writer.endObject();
        } catch (IOException ioe) {
            failed(ioe);
            return;
        }

        int total = contactsPrinted + tagsPrinted;
        if (total <= 0) {
            if (context.corp()) {
                suggestHandler.corpEmptyResponses().accept(1);
            } else {
                suggestHandler.emptyResponses().accept(1);
            }

            if (context.request().contains("@")) {
                if (context.corp()) {
                    suggestHandler.corpEmptyResponseAfterAt().accept(1);
                } else {
                    suggestHandler.emptyResponseAfterAt().accept(1);
                }
            }
        }

        if (context.debug()) {
            context.logger().info(sbw.toString());
        }

        session.response(
            HttpStatus.SC_OK,
            new NStringEntity(
                sbw.toString(),
                ContentType.APPLICATION_JSON
                    .withCharset(context.session().acceptedCharset())));
    }
}
