package ru.yandex.ace.ventura.proxy.suggest;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.ace.ventura.proxy.common.AceVenturaContact;
import ru.yandex.ace.ventura.proxy.common.AceVenturaResultTag;
import ru.yandex.http.util.DoubleFutureCallback;
import ru.yandex.search.rules.pure.SearchRule;

public class TagsAndContactsSuggestRule implements SearchRule<AceVenturaSuggestContext,
    Map.Entry<Collection<AceVenturaContact>, List<AceVenturaResultTag>>>
{
    private final SearchRule<AceVenturaSuggestContext, Collection<AceVenturaContact>> contactsRule;
    private final SearchRule<AceVenturaSuggestContext, List<AceVenturaResultTag>> tagsRule;

    public TagsAndContactsSuggestRule(
        final SearchRule<AceVenturaSuggestContext, Collection<AceVenturaContact>> contactsRule,
        final SearchRule<AceVenturaSuggestContext, List<AceVenturaResultTag>> tagsRule)
    {
        this.contactsRule = contactsRule;
        this.tagsRule = tagsRule;
    }

    @Override
    public void execute(
        final AceVenturaSuggestContext context,
        FutureCallback<? super Map.Entry<Collection<AceVenturaContact>, List<AceVenturaResultTag>>> callback)
        throws HttpException
    {
        DoubleFutureCallback<Collection<AceVenturaContact>, List<AceVenturaResultTag>> dfcb
            = new DoubleFutureCallback<>(callback);
        contactsRule.execute(context, dfcb.first());
        tagsRule.execute(context, dfcb.second());
    }
}
