package ru.yandex.ace.ventura.proxy.suggest.comparator;

import java.util.Comparator;

import ru.yandex.ace.ventura.proxy.common.AceVenturaContact;

public enum ContactsEqualTreatmentComparator implements Comparator<AceVenturaContact> {
    INSTANCE;

    @Override
    public int compare(final AceVenturaContact o1, final AceVenturaContact o2) {
        int usage = Long.compare(o1.lastUsage(), o2.lastUsage());
        if (usage != 0) {
            return -usage;
        }

        return Integer.compare(o1.corpDepDist(), o2.corpDepDist());
    }
}
