package ru.yandex.ace.ventura.proxy.suggest.corp;

import java.util.Collection;

import org.apache.http.HttpException;

import ru.yandex.ace.ventura.AceVenturaFields;
import ru.yandex.ace.ventura.proxy.AceVenturaProxy;
import ru.yandex.ace.ventura.proxy.suggest.AceVenturaEmailSuggestRule;
import ru.yandex.ace.ventura.proxy.suggest.AceVenturaSuggestContext;
import ru.yandex.parser.uri.QueryConstructor;

public class PersonalCorpEmailSuggestRule
    extends AceVenturaEmailSuggestRule<CorpSuggestContext>
{
    private static final String PERS_GET_FIELDS = GET_FIELDS + ",dep_score";
    public PersonalCorpEmailSuggestRule(final AceVenturaProxy proxy) {
        super(proxy);
    }

    @Override
    public StringBuilder prepareQuery(
        final AceVenturaSuggestContext context,
        final Collection<String> requests,
        final String original)
    {
        StringBuilder sb = super.prepareQuery(context, requests, original);
        sb.append(" AND NOT ");
        sb.append(AceVenturaFields.CORP_DISMISSED.prefixed());
        sb.append(":1");
        return sb;
    }

    @Override
    protected QueryConstructor createBaseQuery(
        final CorpSuggestContext context)
        throws HttpException
    {
        QueryConstructor query =
            new QueryConstructor(
                "/search-ace-suggest?IO_PRIO=0&json-type=dollar");

        query.append("service", context.user().service());
        query.append("dp", LEFT_JOIN_DP);
        query.append("get", PERS_GET_FIELDS);
        query.append("length", 2 * context.length());
        query.append("prefix", context.user().prefix().toStringFast());
        query.append("lowercase-expanded-terms", "true");
        query.append("replace-ee-expanded-terms", "true");
        query.append(
            "dp",
            "dep_dist(av_corp_departments," + context.departments() + " dep_score)");

        query.append("sort", AceVenturaFields.LAST_USAGE.stored());

        return query;
    }
}
