package ru.yandex.ace.ventura.proxy.suggest.corp;

import org.apache.http.HttpException;

import ru.yandex.ace.ventura.proxy.AceVenturaProxy;
import ru.yandex.ace.ventura.proxy.suggest.AceVenturaEmailSuggestRule;
import ru.yandex.parser.uri.QueryConstructor;

public class SharedCorpEmailSuggestRule extends AceVenturaEmailSuggestRule<CorpSharedSuggestContext> {
    private static final String SHARED_GET_FIELDS = GET_FIELDS + ",dep_score";
    private static final int DEPARTMENTS_SORT_THRESHOLD = 2;

    public SharedCorpEmailSuggestRule(final AceVenturaProxy proxy) {
        super(proxy);
    }

    @Override
    protected QueryConstructor createBaseQuery(
        final CorpSharedSuggestContext context)
        throws HttpException
    {
        QueryConstructor query =
            new QueryConstructor(
                "/search-ace-suggest?IO_PRIO=0&json-type=dollar");

        query.append("service", context.user().service());
        query.append("dp", LEFT_JOIN_DP);
        query.append("length", context.length());
        query.append("prefix", context.user().prefix().toStringFast());
        query.append("lowercase-expanded-terms", "true");
        query.append("replace-ee-expanded-terms", "true");
        if (!context.departments().isEmpty()
            && context.request().length() >= DEPARTMENTS_SORT_THRESHOLD)
        {
            query.append("dp", "dep_dist(av_corp_departments," + context.departments() + " dep_score)");
            query.append("sort", "dep_score");
            query.append("asc", "true");
            query.append("get", SHARED_GET_FIELDS);
        } else {
            query.append("collector", "passthru(" + context.length() + ')');
            query.append("get", GET_FIELDS);
        }

        return query;
    }
}
