package ru.yandex.ace.ventura.proxy.suggest.tags;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.ace.ventura.AceVenturaFields;
import ru.yandex.ace.ventura.proxy.common.AceVenturaContact;
import ru.yandex.ace.ventura.proxy.common.AceVenturaEmail;
import ru.yandex.ace.ventura.proxy.common.AceVenturaResultTag;
import ru.yandex.ace.ventura.proxy.suggest.AceVenturaSuggestContext;
import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;

public final class TagsSuggestCallback
    extends AbstractFilterFutureCallback<JsonObject,
        List<AceVenturaResultTag>>
{
    private final AceVenturaSuggestContext context;
    private final Map<Integer, String> tags;

    public TagsSuggestCallback(
        final FutureCallback<? super List<AceVenturaResultTag>> callback,
        final AceVenturaSuggestContext context,
        final Map<Integer, String> tags)
    {
        super(callback);
        this.context = context;
        this.tags = tags;
    }

    @Override
    public void completed(final JsonObject response) {
        try {
            JsonMap map = response.asMap();
            //long total = map.getLong("hitsCount");
            JsonList hits = map.getList("hitsArray");

            context.logger().info("By Tags found " + hits.size());
            Map<Integer, AceVenturaResultTag> tagMap =
                new LinkedHashMap<>();

            for (JsonObject item: hits) {
                JsonMap emailRecord = item.asMap();
                String emailStr =
                    emailRecord.getString(AceVenturaFields.EMAIL.stored());
                if (emailStr == null) {
                    continue;
                }
//                    AceVenturaRecordType recordType =
//                        itemMap.getEnum(
//                            AceVenturaRecordType.class,
//                            AceVenturaFields.RECORD_TYPE.storeField());
//                    context.logger().info(
//                        "Item " + JsonType.NORMAL.toString(itemMap));

//                    if (recordType == AceVenturaRecordType.EMAIL) {
                Long cid =
                    emailRecord.getLong(AceVenturaFields.EMAIL_CID.stored());
                AceVenturaEmail email =
                    AceVenturaEmail.fromLuceneResponse(emailRecord);
                AceVenturaContact contact =
                    AceVenturaContact.fromLuceneResponse(
                        context.session().logger(),
                        context.prefix(),
                        emailRecord);
                contact.addEmail(email);

                Set<Integer> found =
                    new LinkedHashSet<>(email.tags());
                found.retainAll(tags.keySet());

                if (found.isEmpty()) {
                    context.logger().info("Strange, tags " + tags
                        + " not found in contact " + email.tags()
                        + " " + JsonType.NORMAL.toString(emailRecord));
                    continue;
                }

                for (Integer tagId: found) {
                    AceVenturaResultTag tag = tagMap.computeIfAbsent(
                        tagId,
                        (k) -> new AceVenturaResultTag(
                            tagId,
                            tags.get(tagId)));

                    AceVenturaContact existing = tag.get(cid);
                    if (existing == null) {
                        tag.add(contact);
                    } else {
                        existing.addEmail(email);
                    }
                }

            }

            callback.completed(new ArrayList<>(tagMap.values()));
        } catch (JsonException je) {
            failed(je);
        }
    }
}
