#!/bin/bash
set -exo pipefail

source acesalo_config.sh
source classpath.sh

CORE_DIR="/cores"
export IBM_HEAPDUMP=1
export IBM_HEAP_DUMP=1
export IBM_COREDIR=$CORE_DIR
export IBM_HEAPDUMPDIR=$CORE_DIR
export IBM_JAVACOREDIR=$CORE_DIR
export LANG=en_US.UTF-8
export LD_LIBRARY_PATH=.

NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"

XMX=$(jq -r '.container.constraints["memory_guarantee"]' $BSCONFIG_IDIR/dump.json | gawk '{print int($1 * 0.8 / 1048576)}')
XMS=$((XMX / 4))
MEM_ARGS="-Xms${XMS}M -Xmx${XMX}M"
DUMP_ARGS=""
NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
APP_ARGS="-DBSCONFIG_IPORT=$BSCONFIG_IPORT
-DBSCONFIG_IHOST=$BSCONFIG_IHOST
-DBSCONFIG_INAME=$BSCONFIG_INAME
-DACEVENTURA_QUEUE=$ACEVENTURA_QUEUE
-DACEVENTURA_SHARD=pg2358
-DTVM_API_HOST=https://tvm-api.yandex.net
-DTVM_CLIENT_ID=$ACESALO_TVM_CLIENT_ID
-DBLACKBOX_CLIENT_ID=222
-DSALO_HOST=$(hostname -f)
"

export ACE_SEARCH_BACKEND_SHARDS=31

GC_ARGS="
-Dorg.apache.commons.logging.Log=org.apache.commons.logging.impl.SimpleLog
-Dorg.apache.commons.logging.simplelog.showdatetime=false
-Dorg.apache.commons.logging.simplelog.log.org.apache.http=OFF
-Dorg.apache.commons.logging.simplelog.log.org.apache.http.wire=OFF
-Xdump:system+heap+java:events=systhrow+user,filter=java/lang/OutOfMemoryError,request=exclusive+prepwalk+compact
-verbose:gc
-Xverbosegclog:/dev/shm/gc.log,10,10000
-Xgcpolicy:gencon"

#ru.yandex.mail.search.staff.StaffConsumerServer aceventura_staff_consumer.conf
exec $BSCONFIG_IDIR/jdk/bin/java \
    -Djava.library.path=aceventura_salo \
    -verbose:gc \
    $NET_ARGS $GC_ARGS $APP_ARGS \
    -DPORTO=1 \
    -cp $CLASSPATH \
    $RUN_CONFIG



