#!/bin/bash
set -exo pipefail

source acesalo_config.sh

PING_PORTS=(
80
81
)

end_date=$(expr $(date +%s) + 3600)
while true
do
    if [ $(date +%s) -ge $end_date ]
    then
        >&2 echo Status script timed out
        exit 1
    fi

    # Fast check, just sleep on failure
    failed=0
    for ping_port in ${PING_PORTS[@]}
    do
        if ! PORT=$ping_port REQUEST_TIMEOUT=30 timeout 60 ./check_http_status.sh
        then
            >&2 echo "Port $ping_port /ping check failed"
            failed=1
            break
        fi
    done

    if [ $failed -eq 1 ]
    then
        sleep 1
        continue
    fi

    break
done

failed=0
for ping_port in ${PING_PORTS[@]}
do
    if ! PORT=$ping_port REQUEST_TIMEOUT=30 timeout 60 ./check_http_status.sh
    then
        >&2 echo "Port $ping_port /ping second check failed"
        exit 1
    fi
done

exit 0
