package ru.yandex.ace.ventura.salo;

import java.io.IOException;
import java.math.BigDecimal;

import ru.yandex.ace.ventura.AceVenturaPrefix;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.search.salo.DatabaseEnvelope;
import ru.yandex.search.salo.Envelope;
import ru.yandex.search.salo.Mdb;

public abstract class AceVenturaEnvelope extends Envelope {
    private final AceVenturaIndexContext context;
    private final AceVenturaPrefix prefix;
    private final int size;

    protected AceVenturaEnvelope(
        final AceVenturaIndexContext context,
        final JsonMap docs,
        final int size)
        throws IOException, JsonException
    {
        this(context, context.prefix(), docs, size);
    }

    protected AceVenturaEnvelope(
        final AceVenturaIndexContext context,
        final AceVenturaPrefix prefix,
        final byte[] data,
        final int size)
    {
        super(data, nextOpId(context), context.envelopesContext());

        this.prefix = prefix;
        this.size = size;
        this.context = context;

        uri.append(luceneMethod());
        uri.append(context.envelopesContext().dbId());
        uri.append("&prefix=");
        uri.append(prefix);
        uri.append("&operation-id=");
        uri.append(context.changeId());
        uri.append("&operation-date=");
        uri.append(context.opDate());
        uri.append("&changed-size=");
        uri.append(size);
        uri.append("&change-id=");
        uri.append(context.changeId());
        uri.append("&change-type=");
        uri.append(context.changeType().lowName());
        uri.append("&revision=");
        uri.append(context.revision());
        uri.append("&select-date=");
        uri.append(context.selectDate());
    }

    protected AceVenturaEnvelope(
        final AceVenturaIndexContext context,
        final AceVenturaPrefix prefix,
        final JsonMap docs,
        final int size)
        throws IOException, JsonException
    {
        this(
            context,
            prefix,
            context.envelopesContext().encode(docs),
            size);
    }

    protected abstract String luceneMethod();

    @Override
    public int shard() {
        return (int) (prefix.hash() % Mdb.SHARDS);
    }

    @Override
    public int midsCount() {
        return size;
    }

    @Override
    protected void writeAdditionalInfo(final StringBuilder sb) {
    }

    @Override
    public boolean optional() {
        return false;
    }

    @Override
    public double operationDate() {
        return context.opDate();
    }

    protected static BigDecimal nextOpId(final AceVenturaIndexContext context) {
        long index = context.nextEnvelopeOffset();
        BigDecimal id = new BigDecimal(context.changeId());

        if (index > 0) {
            id = id.add(
                new BigDecimal(index)
                    .movePointLeft(DatabaseEnvelope.DECIMAL_POINT_SHIFT));
        }

        return id;
    }
}
