package ru.yandex.ace.ventura.salo;

import java.io.IOException;

import ru.yandex.ace.ventura.AceVenturaConstants;
import ru.yandex.ace.ventura.salo.config.ImmutableMdbConfig;
import ru.yandex.search.salo.DatabaseContext;
import ru.yandex.search.salo.EnvelopeFactory;
import ru.yandex.search.salo.Mdb;
import ru.yandex.search.salo.Salo;

public class AceVenturaMdbProvider extends PgMdbProvider {
    private final AceVenturaMdbsContext mdbsContext;

    private final EnvelopeFactory envelopesFactory;

    public AceVenturaMdbProvider(
        final Salo salo,
        final ImmutableMdbConfig config)
    {
        super(salo, config);

        ThreadGroup threadGroup =
            new ThreadGroup(
                salo.getThreadGroup(),
                config.name() + "-Mdbs");

        this.mdbsContext =
            new AceVenturaMdbsContext(salo, threadGroup, config);
        this.envelopesFactory = new AceVenturaEnvelopesFactory(mdbsContext);
    }

    public AceVenturaMdbsContext mdbsContext() {
        return mdbsContext;
    }

    @Override
    public Mdb apply(final String s) throws IOException {
        return new Mdb(
            mdbsContext,
            new DatabaseContext(
                config.name() + '_' + s,
                "mdb=pg&pgshard=" + s,
                envelopesFactory),
            AceVenturaConstants.ACEVENTURA_QUEUE);
    }
}
