package ru.yandex.ace.ventura.salo;

import java.util.Map;

import ru.yandex.ace.ventura.salo.handlers2.AbstractAceVenturaIndexHandler2;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.parser.email.MailAliases;
import ru.yandex.util.string.StringUtils;

public class AceventuraSaloEmail {
    private final String login;
    private final String loginNormalized;
    private final String loginAliases;
    private final String domainNormalized;
    private final String domainNoTopLevel;
    private final boolean validDomain;

    public AceventuraSaloEmail(
        final String login,
        final String loginNormalized,
        final String loginAliases,
        final String domainNormalized,
        final String domainNoTopLevel,
        final boolean validDomain)
    {
        this.login = login;
        this.loginNormalized = loginNormalized;
        this.loginAliases = loginAliases;
        this.domainNormalized = domainNormalized;
        this.domainNoTopLevel = domainNoTopLevel;
        this.validDomain = validDomain;
    }

    public String login() {
        return login;
    }

    public String loginNormalized() {
        return loginNormalized;
    }

    public String loginAliases() {
        return loginAliases;
    }

    public String domainNormalized() {
        return domainNormalized;
    }

    public String domainNoTopLevel() {
        return domainNoTopLevel;
    }

    public boolean validDomain() {
        return validDomain;
    }

    public boolean yaTeamEmail() {
        return validDomain && "yandex-team".equalsIgnoreCase(domainNoTopLevel);
    }


    public static AceventuraSaloEmail parse(final String email, final PrefixedLogger logger) {
        int atIndex = MailAliases.emailSeparatorPos(email);
        if (atIndex <= 0 ) {
            return null;
        }

        Map.Entry<String, String> normalizedPair =
            MailAliases.INSTANCE.parseAndNormalize(email, atIndex);

        String login = email.substring(0, atIndex);

        String loginNormalized = normalizedPair.getKey();
        String domainNormalized = normalizedPair.getValue();

        String loginAliases = login;
        if (!login.equalsIgnoreCase(loginNormalized)) {
            loginAliases = StringUtils.concat(login, '\n', loginNormalized);
        }
        boolean validDomain = AbstractAceVenturaIndexHandler2.DOMAIN_VALIDATOR.matcher(domainNormalized).matches();
        if (!validDomain) {
            logger.warning("Invalid domain " + domainNormalized);
            //return null;
        }
        // it's not goof enough but could work
        int lastDotIndex = domainNormalized.lastIndexOf('.');
        String domainNoTopLevel = domainNormalized.substring(0, lastDotIndex);
        return new AceventuraSaloEmail(
            login,
            loginNormalized,
            loginAliases,
            domainNormalized,
            domainNoTopLevel,
            validDomain);
    }

}
