package ru.yandex.ace.ventura.salo;

import java.util.Locale;

public enum CollieChangeType {
    CREATE_USER,
    DELETE_USER,
    CREATE_LIST,
    DELETE_LIST,
    UPDATE_LIST,
    SHARE_LIST,
    REVOKE_LIST,
    SUBSCRIBED_LISTS,
    SUBSCRIBE_TO_LIST,
    REVOKE_SUBSCRIBED_LIST,
    CREATE_CONTACTS,
    DELETE_CONTACTS,
    UPDATE_CONTACTS,
    CREATE_TAG,
    DELETE_TAG,
    UPDATE_TAG,
    TAG_CONTACTS,
    UNTAG_CONTACTS,
    CREATE_EMAILS,
    DELETE_EMAILS,
    UPDATE_EMAILS,
    TAG_EMAILS,
    UNTAG_EMAILS,
    COPY_ABOOK,
    CREATE_DIRECTORY_ENTITIES,
    DELETE_DIRECTORY_ENTITIES,
    // virtual
    REINDEX_USER;

    private final String lowName;

    CollieChangeType() {
        this.lowName = name().toLowerCase(Locale.ENGLISH);
    }

    public String lowName() {
        return lowName;
    }
}
