package ru.yandex.ace.ventura.salo;

import java.util.List;

import ru.yandex.dbfields.CollieFields;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;

public class EmailInfo {
    private final Long emailId;
    private final Long revision;
    private final String label;
    private final String type;
    private final Long contactId;
    private final List<TagInfo> tags;
    private final String email;

    public EmailInfo(
        final JsonMap emap,
        final List<TagInfo> tags)
        throws JsonException
    {
        this.emailId = emap.getLong(CollieFields.EMAIL_ID);
        this.email = emap.getString(CollieFields.EMAIL);
        this.contactId = emap.getLong(CollieFields.CONTACT_ID);
        String label = emap.getString(CollieFields.EMAIL_LABEL, null);
        if (label != null) {
            this.label = label;
        } else {
            this.label = emap.getString(CollieFields.LABEL, null);
        }

        this.revision = emap.getLong(CollieFields.REVISION);
        String type = emap.getString(CollieFields.EMAIL_TYPE, null);
        if (type != null) {
            this.type = type;
        } else {
            this.type = emap.getString(CollieFields.TYPE, null);
        }

        this.tags = tags;
    }

    public Long emailId() {
        return emailId;
    }

    public List<TagInfo> tags() {
        return tags;
    }

    public String email() {
        return email;
    }

    public Long revision() {
        return revision;
    }

    public String label() {
        return label;
    }

    public String type() {
        return type;
    }

    public Long contactId() {
        return contactId;
    }

    @Override
    public String toString() {
        return "EmailInfo{" +
            "emailId=" + emailId +
            ", revision=" + revision +
            ", label='" + label + '\'' +
            ", type='" + type + '\'' +
            ", contactId=" + contactId +
            ", tags=" + tags +
            ", email='" + email + '\'' +
            '}';
    }
}
