package ru.yandex.ace.ventura.salo;

import java.io.IOException;
import java.util.Map;

import org.apache.http.HttpException;

import ru.yandex.ace.ventura.salo.config.ImmutableMdbConfig;
import ru.yandex.ace.ventura.salo.mdb.SaloShardMap;
import ru.yandex.function.GenericAutoCloseable;
import ru.yandex.function.GenericFunction;
import ru.yandex.search.salo.Mdb;

public interface MdbProvider
    extends GenericAutoCloseable<IOException>, GenericFunction<String, Mdb, IOException>
{
    void start();

    Map<String, Object> status();

    String name();

    void dropPosition(final String name) throws HttpException;

    ImmutableMdbConfig config();

    SaloShardMap shardMap();
}
