package ru.yandex.ace.ventura.salo;

import ru.yandex.ace.ventura.salo.config.ImmutableMdbConfig;
import ru.yandex.search.salo.Salo;

public enum MdbProviderType {
    ACEVENTURA {
        @Override
        public MdbProvider create(
            final Salo salo,
            final ImmutableMdbConfig config)
        {
            return new AceVenturaMdbProvider(salo, config);
        }
    };

    public abstract MdbProvider create(
        final Salo salo,
        final ImmutableMdbConfig config);
}
