package ru.yandex.ace.ventura.salo;

import ru.yandex.ace.ventura.AceVenturaPrefix;
import ru.yandex.http.util.request.RequestHandlerMapper;

public class QueryDeleteAceVenturaEnvelope extends AceVenturaEnvelope {
    private static final byte[] EMPTY = new byte[0];
    private final String query;

    public QueryDeleteAceVenturaEnvelope(
        final AceVenturaIndexContext context,
        final AceVenturaPrefix prefix,
        final String query)
    {
        super(context, prefix, EMPTY, 1);

        this.query = query;

        this.uri.append("&text=");
        this.uri.append(this.query);
    }

    @Override
    protected String luceneMethod() {
        return "/delete?";
    }

    @Override
    public String method() {
        return RequestHandlerMapper.GET;
    }
}
