package ru.yandex.ace.ventura.salo;

import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ShardRemainFilter
    implements Function<Set<String>, Set<String>>
{
    private final int maxShards;
    private final int currentShard;

    public ShardRemainFilter(final int maxShards, final int currentShard) {
        this.maxShards = maxShards;
        this.currentShard = currentShard;
    }

    @Override
    public Set<String> apply(final Set<String> shards) {
        return shards.stream()
            .filter((s) -> s.hashCode() % maxShards == currentShard)
            .collect(Collectors.toSet());
    }
}
