package ru.yandex.ace.ventura.salo;

import ru.yandex.dbfields.CollieFields;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;

public class TagInfo {
    private final long id;
    private final String name;
    private final String type;
    private final long revision;

    public TagInfo(final JsonMap tmap) throws JsonException {
        this.id = tmap.getLong(CollieFields.TAG_ID);
        this.name = tmap.getString(CollieFields.TAG_NAME);
        this.type = tmap.getString(CollieFields.TAG_TYPE);
        this.revision = tmap.getLong(CollieFields.REVISION);
    }

    public TagInfo(
        final long id,
        final String name,
        final String type,
        final long revision)
    {
        this.id = id;
        this.name = name;
        this.type = type;
        this.revision = revision;
    }

    public long id() {
        return id;
    }

    public String name() {
        return name;
    }

    public String type() {
        return type;
    }

    public long revision() {
        return revision;
    }
}
