package ru.yandex.ace.ventura.salo.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.client.tvm2.Tvm2ClientConfigBuilder;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.search.salo.config.AbstractSaloConfigBuilder;
import ru.yandex.stater.StatersConfig;
import ru.yandex.stater.StatersConfigBuilder;

public abstract class AbstractAceVenturaSaloConfigBuilder
    <T extends AbstractAceVenturaSaloConfigBuilder<T>>
     extends AbstractSaloConfigBuilder<T>
     implements AceVenturaSaloConfig
{
    private List<MdbConfigBuilder> providers;
    private HttpHostConfigBuilder blackboxConfig;
    private HttpHostConfigBuilder corpBlackboxConfig;
    private HttpHostConfigBuilder mailProxyConfig;
    private HttpHostConfigBuilder aceventuraProxyConfig;
    private HttpHostConfigBuilder staffConfig;
    private Tvm2ClientConfigBuilder tvm2ClientConfig;
    private String bpBlackboxClientId;
    private String corpBlackboxClientId;
    private String mailProxyClientId;
    private StatersConfigBuilder bpBlackboxStatersConfig;
    private StatersConfigBuilder corpBlackboxStatersConfig;
    private boolean fetchOldAbookUsageOnReindex;
    private boolean skipMalformedUser;

    protected AbstractAceVenturaSaloConfigBuilder(
        final AceVenturaSaloConfig config)
    {
        super(config);

        providers(config.providers());
        blackboxConfig(config.blackboxConfig());
        corpBlackboxConfig(config.corpBlackboxConfig());
        mailProxyConfig(config.mailProxyConfig());
        aceventuraProxyConfig(config.aceventuraProxyConfig());
        tvm2ClientConfig(config.tvm2ClientConfig());
        bpBlackboxClientId(config.bpBlackboxClientId());
        corpBlackboxClientId(config.corpBlackboxClientId());
        mailProxyClientId(config.mailProxyClientId());
        bpBlackboxStatersConfig(config.bpBlackboxStatersConfig());
        corpBlackboxStatersConfig(config.corpBlackboxStatersConfig());
        staffConfig(config.staffConfig());
        fetchOldAbookUsageOnReindex(config.fetchOldAbookUsageOnReindex());
        skipMalformedUser(config.skipMalformedUser());
    }

    protected AbstractAceVenturaSaloConfigBuilder(
        final IniConfig config,
        final AceVenturaSaloConfig defaults)
        throws ConfigException
    {
        super(config, defaults);

        List<MdbConfigBuilder> providers
            = new ArrayList<>();

        for (Map.Entry<String, IniConfig> section
            : config.sections().entrySet())
        {
            if (section.getKey().startsWith("mdb-")) {
                providers.add(
                    new MdbConfigBuilder(
                        section.getValue()));
            }
        }

        // when we were migrating from abook to collie, we also moved contact usage frequency
        // to keep it in idex
        fetchOldAbookUsageOnReindex =
            config.getBoolean(
                "fetch-abook-usage-on-reindex",
                defaults.fetchOldAbookUsageOnReindex());
        skipMalformedUser =
            config.getBoolean(
                "skip-malformed-user",
                defaults.skipMalformedUser());

        IniConfig blackboxSection = config.section("blackbox");
        IniConfig corpBlackboxSection = config.section("corp-blackbox");
        IniConfig mailProxySection = config.section("mail-proxy");
        IniConfig aceventuraProxySection = config.section("aceventura-proxy");
        this.blackboxConfig = new HttpHostConfigBuilder(blackboxSection);
        this.corpBlackboxConfig = new HttpHostConfigBuilder(corpBlackboxSection);

        this.bpBlackboxStatersConfig =
            new StatersConfigBuilder(
                blackboxSection,
                defaults.bpBlackboxStatersConfig());

        this.corpBlackboxStatersConfig =
            new StatersConfigBuilder(
                corpBlackboxSection,
                defaults.corpBlackboxStatersConfig());

        this.mailProxyConfig =
            new HttpHostConfigBuilder(mailProxySection);
        this.aceventuraProxyConfig =
            new HttpHostConfigBuilder(aceventuraProxySection);
        this.staffConfig =
            new HttpHostConfigBuilder(config.section("staff"));

        this.tvm2ClientConfig =
            new Tvm2ClientConfigBuilder(config.section("tvm2"));

        this.bpBlackboxClientId = blackboxSection.getString("client-id");
        this.corpBlackboxClientId = corpBlackboxSection.getString("client-id");
        this.mailProxyClientId = mailProxySection.getString("client-id");
        this.providers = providers;
    }

    @Override
    public List<? extends MdbConfig> providers() {
        return providers;
    }

    public T providers(
        final List<? extends MdbConfig> value)
    {
        List<MdbConfigBuilder> providers = new ArrayList<>();
        for (MdbConfig config: value) {
            providers.add(new MdbConfigBuilder(config));
        }

        this.providers = providers;
        return self();
    }

    @Override
    public HttpHostConfigBuilder blackboxConfig() {
        return blackboxConfig;
    }

    public T blackboxConfig(
        final HttpHostConfig config)
    {
        this.blackboxConfig = new HttpHostConfigBuilder(config);
        return self();
    }

    @Override
    public HttpHostConfigBuilder corpBlackboxConfig() {
        return corpBlackboxConfig;
    }

    public T corpBlackboxConfig(
        final HttpHostConfig config)
    {
        this.corpBlackboxConfig = new HttpHostConfigBuilder(config);
        return self();
    }

    @Override
    public HttpHostConfigBuilder mailProxyConfig() {
        return mailProxyConfig;
    }

    public T mailProxyConfig(final HttpHostConfig config) {
        this.mailProxyConfig = new HttpHostConfigBuilder(config);
        return self();
    }

    @Override
    public HttpHostConfigBuilder aceventuraProxyConfig() {
        return aceventuraProxyConfig;
    }

    public T aceventuraProxyConfig(final HttpHostConfig config) {
        this.aceventuraProxyConfig = new HttpHostConfigBuilder(config);
        return self();
    }

    @Override
    public HttpHostConfigBuilder staffConfig() {
        return staffConfig;
    }

    public T staffConfig(final HttpHostConfig config) {
        this.staffConfig = new HttpHostConfigBuilder(config);
        return self();
    }

    @Override
    public Tvm2ClientConfigBuilder tvm2ClientConfig() {
        return tvm2ClientConfig;
    }

    public T tvm2ClientConfig(final Tvm2ClientConfig config) {
        this.tvm2ClientConfig = new Tvm2ClientConfigBuilder(config);
        return self();
    }

    @Override
    public String bpBlackboxClientId() {
        return bpBlackboxClientId;
    }

    public T bpBlackboxClientId(final String bpBlackboxClientId) {
        this.bpBlackboxClientId = bpBlackboxClientId;
        return self();
    }

    @Override
    public String corpBlackboxClientId() {
        return corpBlackboxClientId;
    }

    public T corpBlackboxClientId(final String corpBlackboxClientId) {
        this.corpBlackboxClientId = corpBlackboxClientId;
        return self();
    }

    @Override
    public String mailProxyClientId() {
        return mailProxyClientId;
    }

    public T mailProxyClientId(final String mailProxyClientId) {
        this.mailProxyClientId = mailProxyClientId;
        return self();
    }

    @Override
    public StatersConfigBuilder bpBlackboxStatersConfig() {
        return bpBlackboxStatersConfig;
    }

    public T bpBlackboxStatersConfig(final StatersConfig config) {
        this.bpBlackboxStatersConfig = new StatersConfigBuilder(config);
        return self();
    }

    @Override
    public StatersConfigBuilder corpBlackboxStatersConfig() {
        return corpBlackboxStatersConfig;
    }

    public T corpBlackboxStatersConfig(final StatersConfig config) {
        this.corpBlackboxStatersConfig = new StatersConfigBuilder(config);
        return self();
    }

    @Override
    public boolean fetchOldAbookUsageOnReindex() {
        return fetchOldAbookUsageOnReindex;
    }

    public T fetchOldAbookUsageOnReindex(
        final boolean fetchOldAbookUsageOnReindex)
    {
        this.fetchOldAbookUsageOnReindex = fetchOldAbookUsageOnReindex;
        return self();
    }

    @Override
    public boolean skipMalformedUser() {
        return skipMalformedUser;
    }

    public T skipMalformedUser(final boolean skipMalformedUser) {
        this.skipMalformedUser = skipMalformedUser;
        return self();
    }
}

