package ru.yandex.ace.ventura.salo.config;

import ru.yandex.ace.ventura.salo.MdbProviderType;
import ru.yandex.ace.ventura.salo.mdb.MdbUpdaterType;
import ru.yandex.ace.ventura.salo.mdb.SaloShardsMapFactory;
import ru.yandex.ace.ventura.salo.mdb.SaloShardsMapFactoryEnum;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractMdbConfigBuilder
    <T extends AbstractMdbConfigBuilder<T>>
     implements MdbConfig
{
    private MdbProviderType mdbProviderType;
    private HttpHostConfigBuilder msalConfig;
    private String name;
    private MdbUpdaterType shardsUpdater;
    private SaloShardsMapFactory shardsMapFactory;
    private long updateInterval;

    protected AbstractMdbConfigBuilder(final MdbConfig config) {
        mdbProviderType(config.mdbProviderType());
        msalConfig(config.msalConfig());
        name(config.name());
        shardsUpdater(config.shardsUpdater());
        shardsMapFactory(config.shardsMapFactory());
        updateInterval(config.updateInterval());
    }

    protected AbstractMdbConfigBuilder(
        final IniConfig config,
        final MdbConfig defaults)
        throws ConfigException
    {
        this.mdbProviderType =
            config.getEnum(
                MdbProviderType.class,
                "envelope-factory-type",
                defaults.mdbProviderType());
        this.msalConfig =
            new HttpHostConfigBuilder(
                config.section("msal"),
                defaults.msalConfig());
        this.name = config.getString("name", defaults.name());
        this.shardsUpdater =
            config.getEnum(
                MdbUpdaterType.class,
                "shards-updater",
                defaults.shardsUpdater());

        IniConfig filterSection =
            config.sectionOrNull("shardsmap");
        if (filterSection != null) {
            this.shardsMapFactory =
                filterSection.getEnum(SaloShardsMapFactoryEnum.class, "type")
                    .create(filterSection);
        } else {
            this.shardsMapFactory = defaults.shardsMapFactory();
        }

        this.updateInterval =
            config.getLongDuration(
                "update-interval",
                defaults.updateInterval());
    }

    protected abstract T self();

    @Override()
    public MdbProviderType mdbProviderType() {
        return mdbProviderType;
    }

    public T mdbProviderType(final MdbProviderType value) {
        this.mdbProviderType = value;
        return self();
    }

    @Override()
    public HttpHostConfigBuilder msalConfig() {
        return msalConfig;
    }

    public T msalConfig(final HttpHostConfig value) {
        this.msalConfig = new HttpHostConfigBuilder(
            value);
        return self();
    }

    @Override()
    public String name() {
        return name;
    }

    public T name(final String value) {
        this.name = value;
        return self();
    }

    @Override()
    public MdbUpdaterType shardsUpdater() {
        return shardsUpdater;
    }

    public T shardsUpdater(final MdbUpdaterType value) {
        this.shardsUpdater = value;
        return self();
    }

    @Override
    public long updateInterval() {
        return updateInterval;
    }

    public T updateInterval(final long updateInterval) {
        this.updateInterval = updateInterval;
        return self();
    }

    @Override
    public SaloShardsMapFactory shardsMapFactory() {
        return shardsMapFactory;
    }

    public T shardsMapFactory(final SaloShardsMapFactory factory) {
        this.shardsMapFactory = factory;
        return self();
    }
}
