package ru.yandex.ace.ventura.salo.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class AceVenturaSaloConfigBuilder
     extends AbstractAceVenturaSaloConfigBuilder<AceVenturaSaloConfigBuilder>
{
    public AceVenturaSaloConfigBuilder() {
        this(AceVenturaSaloConfigDefaults.INSTANCE);
    }

    public AceVenturaSaloConfigBuilder(final AceVenturaSaloConfig config) {
        super(config);
    }

    public AceVenturaSaloConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, AceVenturaSaloConfigDefaults.INSTANCE);
    }

    public AceVenturaSaloConfigBuilder(
        final IniConfig config,
        final AceVenturaSaloConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableAceVenturaSaloConfig build() throws ConfigException {
        return new ImmutableAceVenturaSaloConfig(
            this);
    }

    @Override
    public AceVenturaSaloConfigBuilder self() {
        return this;
    }
}
