package ru.yandex.ace.ventura.salo.config;

import java.util.Collections;
import java.util.List;

import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.client.tvm2.Tvm2ClientConfigDefaults;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.search.salo.config.SaloConfigDefaults;
import ru.yandex.stater.StatersConfig;
import ru.yandex.stater.StatersConfigDefaults;

public class AceVenturaSaloConfigDefaults
     extends SaloConfigDefaults
     implements AceVenturaSaloConfig
{
    public static final AceVenturaSaloConfigDefaults INSTANCE =
        new AceVenturaSaloConfigDefaults();

    protected AceVenturaSaloConfigDefaults() {
    }

    @Override
    public List<? extends MdbConfig> providers() {
        return Collections.emptyList();
    }

    @Override
    public HttpHostConfig blackboxConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig corpBlackboxConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig mailProxyConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig aceventuraProxyConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig staffConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public Tvm2ClientConfig tvm2ClientConfig() {
        return Tvm2ClientConfigDefaults.INSTANCE;
    }

    @Override
    public String bpBlackboxClientId() {
        return null;
    }

    @Override
    public String corpBlackboxClientId() {
        return null;
    }

    @Override
    public String mailProxyClientId() {
        return null;
    }

    @Override
    public StatersConfig bpBlackboxStatersConfig() {
        return StatersConfigDefaults.INSTANCE;
    }

    @Override
    public StatersConfig corpBlackboxStatersConfig() {
        return StatersConfigDefaults.INSTANCE;
    }

    @Override
    public boolean fetchOldAbookUsageOnReindex() {
        return false;
    }

    @Override
    public boolean skipMalformedUser() {
        return false;
    }
}

