package ru.yandex.ace.ventura.salo.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import ru.yandex.client.tvm2.ImmutableTvm2ClientConfig;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.salo.config.ImmutableSaloConfig;
import ru.yandex.stater.ImmutableStatersConfig;

public class ImmutableAceVenturaSaloConfig
     extends ImmutableSaloConfig
     implements AceVenturaSaloConfig
{
    private final List<ImmutableMdbConfig> providers;
    private final ImmutableHttpHostConfig blackboxConfig;
    private final ImmutableHttpHostConfig corpBlackboxConfig;
    private final ImmutableHttpHostConfig mailProxyConfig;
    private final ImmutableHttpHostConfig aceventuraProxyConfig;
    private final ImmutableHttpHostConfig staffConfig;
    private final ImmutableTvm2ClientConfig tvm2ClientConfig;
    private final String bpBlackboxClientId;
    private final String corpBlackboxClientId;
    private final String mailProxyClientId;
    private final ImmutableStatersConfig bpBlackboxStatersConfig;
    private final ImmutableStatersConfig corpBlackboxStatersConfig;
    private final boolean fetchOldAbookUsageOnReindex;
    private final boolean skipMalformedUser;

    public ImmutableAceVenturaSaloConfig(
        final AceVenturaSaloConfig config)
        throws ConfigException
    {
        super(config);
        List<ImmutableMdbConfig> providers = new ArrayList<>();

        for (MdbConfig providerConfig: config.providers()) {
            providers.add(new ImmutableMdbConfig(providerConfig));
        }

        blackboxConfig =
            new ImmutableHttpHostConfig(config.blackboxConfig());
        corpBlackboxConfig =
            new ImmutableHttpHostConfig(config.corpBlackboxConfig());

        mailProxyConfig = new ImmutableHttpHostConfig(config.mailProxyConfig());
        aceventuraProxyConfig = new ImmutableHttpHostConfig(config.aceventuraProxyConfig());
        staffConfig = new ImmutableHttpHostConfig(config.staffConfig());

        tvm2ClientConfig = new ImmutableTvm2ClientConfig(config.tvm2ClientConfig());

        bpBlackboxClientId = config.bpBlackboxClientId();
        corpBlackboxClientId = config.corpBlackboxClientId();

        mailProxyClientId = config.mailProxyClientId();

        this.bpBlackboxStatersConfig =
            new ImmutableStatersConfig(config.bpBlackboxStatersConfig());
        this.corpBlackboxStatersConfig =
            new ImmutableStatersConfig(config.corpBlackboxStatersConfig());

        this.fetchOldAbookUsageOnReindex = config.fetchOldAbookUsageOnReindex();
        this.skipMalformedUser = config.skipMalformedUser();

        this.providers =
            Collections.unmodifiableList(providers);
    }

    @Override
    public List<ImmutableMdbConfig> providers() {
        return providers;
    }

    @Override
    public ImmutableHttpHostConfig blackboxConfig() {
        return blackboxConfig;
    }

    @Override
    public ImmutableHttpHostConfig corpBlackboxConfig() {
        return corpBlackboxConfig;
    }

    @Override
    public ImmutableHttpHostConfig mailProxyConfig() {
        return mailProxyConfig;
    }

    @Override
    public ImmutableTvm2ClientConfig tvm2ClientConfig() {
        return tvm2ClientConfig;
    }

    @Override
    public String bpBlackboxClientId() {
        return bpBlackboxClientId;
    }

    @Override
    public String corpBlackboxClientId() {
        return corpBlackboxClientId;
    }

    @Override
    public String mailProxyClientId() {
        return mailProxyClientId;
    }

    @Override
    public ImmutableStatersConfig bpBlackboxStatersConfig() {
        return bpBlackboxStatersConfig;
    }

    @Override
    public ImmutableStatersConfig corpBlackboxStatersConfig() {
        return corpBlackboxStatersConfig;
    }

    @Override
    public ImmutableHttpHostConfig staffConfig() {
        return staffConfig;
    }

    @Override
    public boolean fetchOldAbookUsageOnReindex() {
        return fetchOldAbookUsageOnReindex;
    }

    @Override
    public boolean skipMalformedUser() {
        return skipMalformedUser;
    }

    @Override
    public ImmutableHttpHostConfig aceventuraProxyConfig() {
        return aceventuraProxyConfig;
    }
}

