package ru.yandex.ace.ventura.salo.config;

import ru.yandex.ace.ventura.salo.MdbProviderType;
import ru.yandex.ace.ventura.salo.mdb.MdbUpdaterType;
import ru.yandex.ace.ventura.salo.mdb.SaloShardsMapFactory;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableMdbConfig implements MdbConfig {
    private final MdbProviderType mdbProviderType;
    private final ImmutableHttpHostConfig msalConfig;
    private final String name;
    private final MdbUpdaterType shardsUpdater;
    private final SaloShardsMapFactory shardsMapFactory;
    private final long updateInterval;

    public ImmutableMdbConfig(
        final MdbConfig config)
        throws ConfigException
    {
        this.mdbProviderType = config.mdbProviderType();
        this.msalConfig = new ImmutableHttpHostConfig(
            config.msalConfig());
        this.name = config.name();
        this.shardsUpdater = config.shardsUpdater();
        this.shardsMapFactory = config.shardsMapFactory();
        this.updateInterval = config.updateInterval();
    }

    @Override
    public MdbProviderType mdbProviderType() {
        return mdbProviderType;
    }

    @Override
    public ImmutableHttpHostConfig msalConfig() {
        return msalConfig;
    }

    @Override
    public String name() {
        return name;
    }

    @Override
    public MdbUpdaterType shardsUpdater() {
        return shardsUpdater;
    }

    @Override
    public SaloShardsMapFactory shardsMapFactory() {
        return shardsMapFactory;
    }

    @Override
    public long updateInterval() {
        return updateInterval;
    }
}
