package ru.yandex.ace.ventura.salo.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class MdbConfigBuilder
     extends AbstractMdbConfigBuilder<MdbConfigBuilder>
{
    public MdbConfigBuilder() {
        this(MdbConfigDefaults.INSTANCE);
    }

    public MdbConfigBuilder(final MdbConfig config) {
        super(config);
    }

    public MdbConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, MdbConfigDefaults.INSTANCE);
    }

    public MdbConfigBuilder(
        final IniConfig config,
        final MdbConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableMdbConfig build() throws ConfigException {
        return new ImmutableMdbConfig(
            this);
    }

    @Override
    public MdbConfigBuilder self() {
        return this;
    }
}
