package ru.yandex.ace.ventura.salo.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

import ru.yandex.ace.ventura.salo.ShardRemainFilter;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public enum MdbFilterFactory {
    FILE_FILTER_MAP {
        @Override
        Function<Set<String>, Set<String>> create(
            final IniConfig config)
            throws ConfigException
        {
            File file = config.getInputFile("filter_file");
            String currentHost = System.getProperty("SALO_HOST");
            int maxShard = -1;
            int currentShard = -1;
            try {
                List<String> lines =
                    Files.readAllLines(Paths.get(file.toURI()));
                for (String line: lines) {
                    if (line.isEmpty()) {
                        continue;
                    }

                    line = line.trim();
                    if (line.startsWith("#")) {
                        continue;
                    }

                    String[] split = line.split("\t");
                    if (split.length != 3) {
                        throw new ConfigException(
                            "Bad formatted line " + split[1]);
                    }

                    Integer shard = Integer.parseInt(split[1].trim());
                    String host = split[0].trim();
                    if (host.equalsIgnoreCase(currentHost)) {
                        currentShard = shard;
                    }

                    if (shard > maxShard) {
                        maxShard = shard;
                    }
                }
            } catch (IOException ioe) {
                throw new ConfigException("Bad formatted file " + file, ioe);
            }

            if (currentShard < 0 || maxShard <= 0) {
                throw new ConfigException(
                    "Host not found in searchmap or bad formatted map "
                        + currentHost + ' ' + currentShard + ' ' + maxShard);
            }

            return new ShardRemainFilter(maxShard + 1, currentShard);
        }
    };

    abstract Function<Set<String>, Set<String>> create(
        final IniConfig config)
        throws ConfigException;
}
