package ru.yandex.ace.ventura.salo.handlers;

import java.io.IOException;
import java.util.List;

import ru.yandex.ace.ventura.salo.AceVenturaIndexContext;
import ru.yandex.ace.ventura.salo.AceVenturaIndexHandler;
import ru.yandex.json.parser.JsonException;
import ru.yandex.search.salo.Envelope;
import ru.yandex.search.salo.Mdb;
import ru.yandex.search.salo.PingEnvelope;

public class AceVenturaEmptyHandler implements AceVenturaIndexHandler {
    public static final AceVenturaEmptyHandler INSTANCE =
        new AceVenturaEmptyHandler();

    private AceVenturaEmptyHandler() {
    }

    @Override
    public void handle(
        final AceVenturaIndexContext context,
        final List<Envelope> storage)
        throws IOException, JsonException
    {
        StringBuilder log = new StringBuilder("Ignoring ");
        log.append(context.changeType());
        log.append(' ');
        log.append(context.changeId());
        log.append(' ');
        log.append(context.prefix());
        context.logger().info(log.toString());

        storage.add(
            new PingEnvelope(
                context.changeId(),
                context.envelopesContext(),
                (int) (context.prefix().hash() % Mdb.SHARDS)));
    }
}
