package ru.yandex.ace.ventura.salo.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.ace.ventura.AceVenturaPrefix;
import ru.yandex.ace.ventura.salo.AceVenturaIndexContext;
import ru.yandex.ace.ventura.salo.EmailInfo;
import ru.yandex.ace.ventura.salo.TagInfo;
import ru.yandex.ace.ventura.salo.handlers2.AbstractAceVenturaIndexHandler2;
import ru.yandex.dbfields.CollieFields;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.search.salo.Envelope;

public class ReindexContext {
    private final AceVenturaIndexContext context;
    private final List<Envelope> storage;
    private final Map<Long, List<EmailInfo>> emails;
    private final Map<Long, List<TagInfo>> taggedContacts;
    private final Map<Long, TagInfo> tagsMap;

    public ReindexContext(
        final AceVenturaIndexContext context,
        final List<Envelope> storage)
        throws JsonException, IOException
    {
        this.storage = storage;
        this.context = context;
        long start = System.currentTimeMillis();

//        Future<JsonObject> emailListFuture =
//            context.asyncMsalRequest(
//                context.prefix(),
//                new StringBuilder(AbstractAceVenturaIndexHandler2.GET_EMAILS_INFO));

//        JsonList emailList;
        JsonList emailList =
            context.msalRequest(
                context.prefix(),
                new StringBuilder(AbstractAceVenturaIndexHandler2.GET_EMAILS_INFO));


        StringBuilder logSb = new StringBuilder(context.prefix().toStringFast());

//        logSb.append(" in ");
//        logSb.append(System.currentTimeMillis() - start);
//
//        Future<JsonObject> tagsListFuture =
//            context.asyncMsalRequest(context.prefix(),
//                new StringBuilder(AbstractAceVenturaIndexHandler2.GET_TAGS));

//        JsonList tagsList;
        JsonList tagsList =
            context.msalRequest(context.prefix(),
                new StringBuilder(AbstractAceVenturaIndexHandler2.GET_TAGS));

//        if (tagsList.size() > 0) {
//            logSb.append(" TaggedContacts:");
//            logSb.append(tagsList.size());
//        }
//
//        logSb.append(" ctags in ");
//        logSb.append(System.currentTimeMillis() - start);

//        Future<JsonObject> taggedContactsFuture
//            = context.asyncMsalRequest(
//                context.prefix(),
//            new StringBuilder(AbstractAceVenturaIndexHandler2.GET_TAGGED_CONTACTS));

//        JsonList taggedContactsList;
        JsonList taggedContactsList = context.msalRequest(context.prefix(),
                new StringBuilder(AbstractAceVenturaIndexHandler2.GET_TAGGED_CONTACTS));
//
//        logSb.append(" tagged-contacts in ");
//        logSb.append(System.currentTimeMillis() - start);

//        Future<JsonObject> taggedEmailsFuture =
//            context.asyncMsalRequest(context.prefix(),
//                new StringBuilder(AbstractAceVenturaIndexHandler2.GET_TAGGED_EMAILS));

        JsonList taggedEmailsList = context.msalRequest(context.prefix(),
                new StringBuilder(AbstractAceVenturaIndexHandler2.GET_TAGGED_EMAILS));
//
//        logSb.append(" tagged-emails in ");
//        logSb.append(System.currentTimeMillis() - start);

//        try {
//            emailList = emailListFuture.get().asList();
//            tagsList = tagsListFuture.get().asList();
//            taggedContactsList = taggedContactsFuture.get().asList();
//            taggedEmailsList = taggedEmailsFuture.get().asList();
//        } catch (ExecutionException e) {
//            throw new AceVenturaIndexException("Failed to request msal",
//                new AceVenturaIndexException(e.getCause().getMessage(), e.getCause()));
//        } catch (InterruptedException e) {
//            throw new AceVenturaIndexException(e);
//        }
        logSb.append(" Reindex msal requests in ");
        logSb.append(System.currentTimeMillis() - start);
        logSb.append(" Emails: ");
        logSb.append(emailList.size());
        if (taggedEmailsList.size() > 0) {
            logSb.append(" TaggedEmails:");
            logSb.append(taggedEmailsList.size());
        }

        if (taggedContactsList.size() > 0) {
            logSb.append(" TaggedContacts:");
            logSb.append(taggedContactsList.size());
        }

        tagsMap = new LinkedHashMap<>(tagsList.size());
        for (JsonObject jo: tagsList) {
            TagInfo info = new TagInfo(jo.asMap());
            tagsMap.put(info.id(), info);
        }

        Map<Long, List<TagInfo>> taggedEmails = Collections.emptyMap();
        if (taggedEmailsList.size() > 0) {
            taggedEmails = new LinkedHashMap<>(taggedEmailsList.size());

            for (JsonObject tagEntry: taggedEmailsList) {
                Long tagId = tagEntry.asMap().getLong(CollieFields.TAG_ID);
                Long emailId =
                    tagEntry.asMap().getLong(CollieFields.EMAIL_ID);

                TagInfo tagInfo = tagsMap.get(tagId);
                if (tagInfo == null) {
                    context.logger().warning(
                        "Not found email tag " + tagId
                            + ' ' + context.prefix().toString()
                            + ' ' + context.toString());
                    continue;
                }

                taggedEmails.computeIfAbsent(
                    emailId,
                    (e) -> new ArrayList<>()).add(tagInfo);
            }
        }

        Map<Long, List<TagInfo>> taggedContacts = Collections.emptyMap();
        if (taggedContactsList.size() > 0) {
            taggedContacts = new LinkedHashMap<>(taggedContactsList.size());
            for (JsonObject contactEntry: taggedContactsList) {
                Long tagId = contactEntry.asMap().getLong(CollieFields.TAG_ID);
                Long cid = contactEntry.asMap().getLong(CollieFields.CONTACT_ID);
                TagInfo tagInfo = tagsMap.get(tagId);
                if (tagInfo == null) {
                    context.logger().warning(
                        "Not found contacts tag " + tagId
                            + ' ' + context.prefix().toString()
                            + ' ' + context.toString());
                    continue;
                }

                taggedContacts.computeIfAbsent(
                    cid,
                    (c) -> new ArrayList<>()).add(tagInfo);
            }
        }

        this.taggedContacts = taggedContacts;

        emails = new LinkedHashMap<>(emailList.size());
        for (JsonObject jo: emailList) {
            JsonMap emap = jo.asMap();
            Long eid = emap.getLong(CollieFields.EMAIL_ID);

            EmailInfo emailInfo =
                new EmailInfo(
                    emap,
                    taggedEmails.getOrDefault(
                        eid,
                        Collections.emptyList()));

            emails.computeIfAbsent(
                emailInfo.contactId(),
                (c) -> new ArrayList<>()).add(emailInfo);
        }

        logger().fine(logSb.toString());
    }

    public AceVenturaIndexContext context() {
        return context;
    }

    public List<Envelope> storage() {
        return storage;
    }

    public List<EmailInfo> emails(final Long cid) {
        return emails.getOrDefault(cid, Collections.emptyList());
    }

    public List<TagInfo> contactTags(final Long cid) {
        return taggedContacts.getOrDefault(cid, Collections.emptyList());
    }

    public AceVenturaPrefix owner() {
        return context.prefix();
    }

    public PrefixedLogger logger() {
        return context.logger();
    }

    public Map<Long, TagInfo> tagsMap() {
        return tagsMap;
    }
}
