package ru.yandex.ace.ventura.salo.handlers;

import java.io.IOException;
import java.util.List;

import ru.yandex.ace.ventura.salo.AceVenturaIndexContext;
import ru.yandex.ace.ventura.salo.AceVenturaMdbsContext;
import ru.yandex.ace.ventura.salo.handlers2.AbstractAceVenturaIndexHandler2;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.search.salo.Envelope;

public class ReindexHandler extends AbstractAceVenturaIndexHandler2 {
    public ReindexHandler(final AceVenturaMdbsContext context) {
        super(context);
    }

    @Override
    public void handle(
        final AceVenturaIndexContext context,
        final List<Envelope> storage)
        throws JsonException, IOException
    {
        JsonList lists = context.msalRequest(
            context.prefix(),
            new StringBuilder("/get-contacts-list?"));

        ReindexContext reindexContext = new ReindexContext(context, storage);

        reindexContext.logger().info("Reindexing lists " + lists.size());
        for (JsonObject listObj: lists) {
            reindexList(reindexContext, listObj.asMap(), true);
        }
    }
}
