package ru.yandex.ace.ventura.salo.handlers;

import java.io.IOException;
import java.util.List;

import ru.yandex.ace.ventura.salo.AceVenturaIndexContext;
import ru.yandex.ace.ventura.salo.AceVenturaIndexException;
import ru.yandex.ace.ventura.salo.AceVenturaIndexHandler;
import ru.yandex.json.parser.JsonException;
import ru.yandex.search.salo.Envelope;

public class UnknownAceVenturaHandler implements AceVenturaIndexHandler {
    public static final UnknownAceVenturaHandler INSTANCE
        = new UnknownAceVenturaHandler();

    private UnknownAceVenturaHandler() {
    }

    @Override
    public void handle(
        final AceVenturaIndexContext context,
        final List<Envelope> storage)
        throws IOException, JsonException
    {
        throw new AceVenturaIndexException(
            "Unknown change_type "
                + context.changeType()
                + " "
                + context.toString());
    }
}
