package ru.yandex.ace.ventura.salo.handlers2;

import java.util.function.BiFunction;

import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.JsonString;

public enum AceVenturaHandlerUtils {
    INSTANCE;

    public BiFunction<JsonObject, JsonMap, JsonMap> makeSet(
        final String field)
    {
        return setOperation("make_set", field);
    }

    public BiFunction<JsonObject, JsonMap, JsonMap> removeSet(
        final String field)
    {
        return setOperation("remove_set", field);
    }

    public BiFunction<JsonObject, JsonMap, JsonMap> setOperation(
        final String operation,
        final String field)
    {
        JsonMap get = new JsonMap(BasicContainerFactory.INSTANCE);
        get.put("function", new JsonString("get"));
        JsonList getArgs = new JsonList(BasicContainerFactory.INSTANCE);
        getArgs.add(new JsonString(field));
        get.put("args", getArgs);

        return new BiFunction<JsonObject, JsonMap, JsonMap>() {
            @Override
            public JsonMap apply(final JsonObject value, final JsonMap map) {
                JsonMap makeSet = new JsonMap(BasicContainerFactory.INSTANCE);
                makeSet.put("function", new JsonString(operation));
                JsonList args = new JsonList(BasicContainerFactory.INSTANCE);
                args.add(value);
                args.add(get);
                makeSet.put("args", args);
                map.put(field, makeSet);
                return map;
            }
        };
    }
}
