package ru.yandex.ace.ventura.salo.handlers2;

import java.io.IOException;
import java.util.List;

import ru.yandex.ace.ventura.AceVenturaFields;
import ru.yandex.ace.ventura.AceVenturaRecordType;
import ru.yandex.ace.ventura.salo.AceVenturaIndexContext;
import ru.yandex.ace.ventura.salo.AceVenturaIndexException;
import ru.yandex.ace.ventura.salo.AceVenturaMdbsContext;
import ru.yandex.ace.ventura.salo.QueryDeleteAceVenturaEnvelope;
import ru.yandex.ace.ventura.salo.handlers.ReindexContext;
import ru.yandex.concurrent.TimeFrameQueue;
import ru.yandex.dbfields.CollieFields;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.search.salo.Envelope;
import ru.yandex.search.salo.Mdb;
import ru.yandex.search.salo.PingEnvelope;

public class CopyAbookHandler extends AbstractAceVenturaIndexHandler2 {
    private final TimeFrameQueue<Long> badUsers;
    public CopyAbookHandler(final AceVenturaMdbsContext context) {
        super(context);

        this.badUsers = context.badUsers();
    }

    @Override
    public void handle(
        final AceVenturaIndexContext context,
        final List<Envelope> storage)
        throws JsonException, IOException
    {
        long start = System.currentTimeMillis();
        List<JsonObject> docs =
            context.changed().getListOrNull(CollieFields.LIST_IDS);

        sendCleanUp(context, storage);
        if (docs == null) {
            context.logger().warning("No list ids supplied " + context);
            return;
        }

        ReindexContext reindexContext;
        try {
            reindexContext = new ReindexContext(context, storage);
        } catch (AceVenturaIndexException aie) {
            if (aie.getCause() != null
                && aie.getCause() instanceof AceVenturaIndexException)
            {
                String response = aie.getCause().getMessage();
                context.logger().warning("CopyAbook failed with msal error " + response);

                if (response != null
                    && response.contains("uid not found: empty subscription.suid.2 in blackbox result"))
                {
                    context.logger().warning("Skipping invalid user " + context.prefix());
                    badUsers.accept(1L);
                    storage.add(
                        new PingEnvelope(
                            context.changeId(),
                            context.envelopesContext(),
                            (int) (context.prefix().hash() % Mdb.SHARDS)));
                    return;
                }
            }

            throw aie;
        }

        StringBuilder logSb = new StringBuilder("Prepared in ");
        long prepared = System.currentTimeMillis();
        logSb.append(prepared - start);

        reindexTags(reindexContext, reindexContext.tagsMap().values());

        long tags = System.currentTimeMillis();
        logSb.append(" tags reindexed in ");
        logSb.append(tags - prepared);
        logSb.append(" Lists ");
        logSb.append(docs.size());

        for (JsonObject listIdObj : docs) {
            reindexList(reindexContext, listIdObj.asLong(), true);
        }

        logSb.append("  in ");
        logSb.append(System.currentTimeMillis() - tags);
        logSb.append(" total ");
        logSb.append(System.currentTimeMillis() - start);
        context.logger().info(logSb.toString());
    }

    protected static void sendCleanUp(
        final AceVenturaIndexContext context,
        final List<Envelope> storage)
    {
        StringBuilder querySb = new StringBuilder();
        querySb.append(AceVenturaFields.RECORD_TYPE.prefixed());
        querySb.append(":(");
        querySb.append(AceVenturaRecordType.CONTACT.fieldValue());
        querySb.append("+OR+");
        querySb.append(AceVenturaRecordType.EMAIL.fieldValue());
        querySb.append("+OR+");
        querySb.append(AceVenturaRecordType.TAG.fieldValue());
        querySb.append(")");

        storage.add(new QueryDeleteAceVenturaEnvelope(context, context.prefix(), querySb.toString()));
    }
}
