package ru.yandex.ace.ventura.salo.handlers2;

import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.TypesafeValueContentHandler;
import ru.yandex.json.parser.JsonException;

public class HumanNamesUtil {
    private final Map<String, String[]> humanAliases;

    public HumanNamesUtil(final Reader source) throws IOException {
        Map<String, String[]> humanAliases;
        try {
            JsonMap root =
                TypesafeValueContentHandler.parse(source).asMap();
            humanAliases = new LinkedHashMap<>(root.size());
            for (Map.Entry<String, JsonObject> entry: root.entrySet()) {
                JsonList jsonAliases = entry.getValue().asList();
                String[] aliases = new String[jsonAliases.size() + 1];
                aliases[0] = entry.getKey();
                for (int i = 0; i < jsonAliases.size(); i++)  {
                    aliases[i + 1] = jsonAliases.get(i).asString();
                }

                for (String alias: aliases) {
                    humanAliases.put(alias.toLowerCase(Locale.ROOT), aliases);
                }
            }
        } catch (JsonException je) {
            throw new IOException(je);
        }

        this.humanAliases = Collections.unmodifiableMap(humanAliases);
    }

    public String[] aliases(final String name) {
        String low = name.toLowerCase(Locale.ROOT);
        return humanAliases.get(low);
    }
}
