package ru.yandex.ace.ventura.salo.handlers2;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class PhonesUtil {
    // in general we should use prefix tree here, o use libphone library
    // but now use this
    private static final Map<String, String> PREFIXES;
    private static final Set<String> CODES;

    static {
        Map<String, String> prefixes = new LinkedHashMap<>();
        prefixes.put("RU/KZ", "+7");
        prefixes.put("LT", "+370");
        prefixes.put("LV", "+371");
        prefixes.put("EE", "+372");
        prefixes.put("MD", "+373");
        prefixes.put("AM", "+374");
        prefixes.put("BL", "+375");
        prefixes.put("UA", "+380");
        prefixes.put("TJ", "+992");
        prefixes.put("TM", "+993");
        prefixes.put("AR", "+994");
        prefixes.put("GE", "+995");
        prefixes.put("KG", "+996");
        prefixes.put("UZ", "+998");
        prefixes.put("TR", "+90");

        PREFIXES = Collections.unmodifiableMap(prefixes);
        CODES =
            Collections.unmodifiableSet(new LinkedHashSet<>(prefixes.values()));
    }

    public static Map<String, String> prefixes() {
        return PREFIXES;
    }

    public static String cutPrefixOrNull(final String phone) {
        if (phone.isEmpty()) {
            return null;
        }

        String cutted = null;
        if (phone.charAt(0) == '+') {
            for (String prefix: CODES) {
                if (phone.startsWith(prefix)) {
                    cutted = phone.substring(prefix.length());
                    break;
                }
            }
        } else if (phone.charAt(0) == '8') {
            cutted = phone.substring(1);
        }

        return cutted;
    }


}
