package ru.yandex.ace.ventura.salo.handlers2;

import java.io.IOException;
import java.util.List;

import ru.yandex.ace.ventura.salo.AceVenturaIndexContext;
import ru.yandex.ace.ventura.salo.AceVenturaMdbsContext;
import ru.yandex.ace.ventura.salo.handlers2.reindex.ContactsReindexUserHandler;
import ru.yandex.json.parser.JsonException;
import ru.yandex.search.salo.Envelope;

public class ReindexUserWithCleanupHandler extends AbstractAceVenturaIndexHandler2 {
    private final ContactsReindexUserHandler reindexHandler;

    public ReindexUserWithCleanupHandler(
        final AceVenturaMdbsContext context,
        final boolean keepUsageStats)
    {
        super(context);

        reindexHandler = new ContactsReindexUserHandler(context, keepUsageStats);
    }

    @Override
    public void handle(
        final AceVenturaIndexContext context,
        final List<Envelope> storage)
        throws IOException, JsonException
    {
        CopyAbookHandler.sendCleanUp(context, storage);
        reindexHandler.handle(context, storage);
    }
}
