package ru.yandex.ace.ventura.salo.handlers2.contacts;

import java.io.IOException;
import java.util.Collections;
import java.util.List;

import ru.yandex.ace.ventura.AceVenturaFields;
import ru.yandex.ace.ventura.salo.AceVenturaIndexContext;
import ru.yandex.ace.ventura.salo.AceVenturaIndexException;
import ru.yandex.ace.ventura.salo.AceVenturaMdbsContext;
import ru.yandex.ace.ventura.salo.ModifyAceVenturaEnvelope;
import ru.yandex.ace.ventura.salo.handlers2.AbstractAceVenturaIndexHandler2;
import ru.yandex.dbfields.CollieFields;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonLong;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonString;
import ru.yandex.json.parser.JsonException;
import ru.yandex.search.salo.Envelope;

public class CreateContactsHandler extends AbstractAceVenturaIndexHandler2 {
    public CreateContactsHandler(final AceVenturaMdbsContext context) {
        super(context);
    }

    @Override
    public void handle(
        final AceVenturaIndexContext context,
        final List<Envelope> storage)
        throws JsonException, IOException
    {
        JsonMap result = new JsonMap(BasicContainerFactory.INSTANCE);
        result.put("prefix", new JsonString(context.prefix().toStringFast()));
        JsonList docs = updateDocs(context);
        result.put("docs", docs);
        storage.add(
            new ModifyAceVenturaEnvelope(context, result, docs.size()));
    }

    protected JsonList updateDocs(
        final AceVenturaIndexContext context)
        throws JsonException, IOException
    {
        JsonList list = new JsonList(BasicContainerFactory.INSTANCE);
        JsonList contacts = context.arguments().getList(CollieFields.CONTACTS);
        JsonList contactIds =
            context.changed().getList(CollieFields.CONTACT_IDS);
        if (contactIds.size() != contacts.size()) {
            throw new AceVenturaIndexException(
                "Different array sizes in arguments and changed ids:"
                    + contactIds.size() + " contacts: " + contacts.size());
        }
        for (int i = 0; i < contactIds.size(); i++) {
            JsonMap contact = contacts.get(i).asMap();
            contact.put(CollieFields.CONTACT_ID, contactIds.get(i));

            contact = buildContact(
                contact,
                context.prefix(),
                context.prefix(),
                Collections.emptyList(),
                false);
            contact.put(
                AceVenturaFields.REVISION.stored(),
                new JsonLong(context.revision()));

            addEnNamesToStaffContact(context, contact, contactIds.get(i).asLong());
            list.add(contact);
        }

        return list;
    }
}
