package ru.yandex.ace.ventura.salo.handlers2.contacts;

import java.io.IOException;
import java.util.List;

import ru.yandex.ace.ventura.AceVenturaFields;
import ru.yandex.ace.ventura.salo.AceVenturaIndexContext;
import ru.yandex.ace.ventura.salo.AceVenturaMdbsContext;
import ru.yandex.ace.ventura.salo.DeleteAceVenturaEnvelope;
import ru.yandex.ace.ventura.salo.handlers2.AbstractAceVenturaIndexHandler2;
import ru.yandex.dbfields.CollieFields;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonString;
import ru.yandex.json.parser.JsonException;
import ru.yandex.search.salo.Envelope;

public class DeleteContactsHandler extends AbstractAceVenturaIndexHandler2 {
    public DeleteContactsHandler(final AceVenturaMdbsContext context) {
        super(context);
    }

    @Override
    public void handle(
        final AceVenturaIndexContext context,
        final List<Envelope> storage)
        throws JsonException, IOException
    {
        JsonMap result = new JsonMap(BasicContainerFactory.INSTANCE);
        result.put("prefix", new JsonString(context.prefix().toStringFast()));
        JsonList docsList = new JsonList(BasicContainerFactory.INSTANCE);

        JsonList contactIds =
            context.arguments().getList(CollieFields.CONTACT_IDS);

        for (int i = 0; i < contactIds.size(); i++) {
            String contactId = contactIds.get(i).asString();

            JsonMap luceneDoc = new JsonMap(BasicContainerFactory.INSTANCE);
            luceneDoc.put(
                AceVenturaFields.ID.stored(),
                new JsonString(
                    AceVenturaFields.contactUrl(
                        contactId,
                        context.prefix(),
                        context.prefix())));
            docsList.add(luceneDoc);
        }

        result.put("docs", docsList);

        storage.add(
            new DeleteAceVenturaEnvelope(context, result, docsList.size()));
    }
}
