package ru.yandex.ace.ventura.salo.handlers2.contacts;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.ace.ventura.AceVenturaFields;
import ru.yandex.ace.ventura.AceVenturaRecordType;
import ru.yandex.ace.ventura.salo.AceVenturaIndexContext;
import ru.yandex.ace.ventura.salo.AceVenturaMdbsContext;
import ru.yandex.ace.ventura.salo.UpdateAceVenturaEnvelope;
import ru.yandex.ace.ventura.salo.handlers2.AbstractAceVenturaIndexHandler2;
import ru.yandex.dbfields.CollieFields;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonBoolean;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.JsonString;
import ru.yandex.json.parser.JsonException;
import ru.yandex.search.salo.Envelope;

public class UpdateContactsHandler extends AbstractAceVenturaIndexHandler2 {
    private static final String EMAILS_QUERY =
        AceVenturaFields.RECORD_TYPE.prefixed()
            + ':'
            + AceVenturaRecordType.EMAIL.fieldValue()
            + " AND "
            + AceVenturaFields.EMAIL_CID.prefixed()
            + ':';

    public UpdateContactsHandler(final AceVenturaMdbsContext context) {
        super(context);
    }

    protected JsonMap buildUpdatedEmail(final JsonMap contact) {
        JsonMap result = new JsonMap(BasicContainerFactory.INSTANCE);
        result.put(
            AceVenturaFields.HAS_PHONES.stored(),
            contact.get(AceVenturaFields.HAS_PHONES.field()));
        result.put(
            AceVenturaFields.LIST_ID.stored(),
            contact.get(AceVenturaFields.LIST_ID.field()));
        result.put(
            AceVenturaFields.NAMES.stored(),
            contact.get(AceVenturaFields.NAMES.field()));
        if (contact.containsKey(AceVenturaFields.EN_NAMES.stored())) {
            result.put(
                AceVenturaFields.EN_NAMES.stored(),
                contact.get(AceVenturaFields.EN_NAMES.field()));
        }

        result.put(
            AceVenturaFields.NAMES_ALIAS.stored(),
            contact.get(AceVenturaFields.NAMES_ALIAS.field()));
        return result;
    }

    @Override
    public void handle(
        final AceVenturaIndexContext context,
        final List<Envelope> storage)
        throws JsonException, IOException
    {
        JsonString prefixJo = new JsonString(context.prefix().toStringFast());
        JsonMap contactRes = new JsonMap(BasicContainerFactory.INSTANCE);
        contactRes.put("prefix", prefixJo);
        contactRes.put("AddIfNotExists", JsonBoolean.TRUE);

        JsonList contactsDocs = new JsonList(BasicContainerFactory.INSTANCE);

        JsonList oldData = context.changed().getList(CollieFields.CONTACTS);
        Map<Long, JsonMap> oldDataMap = new LinkedHashMap<>();
        for (JsonObject contactObj: oldData) {
            JsonMap map = contactObj.asMap();
            Long cid = map.getLong(CollieFields.CONTACT_ID);
            oldDataMap.put(cid, map);
        }

        for (JsonObject contactObj: context.arguments().getList(CollieFields.CONTACTS)) {
            JsonMap updated = contactObj.asMap();
            Long cid = updated.getLong(CollieFields.CONTACT_ID);

            JsonMap old = oldDataMap.get(cid);
            if (old == null) {
                throw new IOException("Can not find email in changed field " + cid);
            }

            JsonMap contact = merge(old, updated);

            JsonMap luceneContact =
                buildContact(
                    contact,
                    context.prefix(),
                    context.prefix(),
                    Collections.emptyList(),
                    true);

            addEnNamesToStaffContact(context, luceneContact, cid);
            contactsDocs.add(luceneContact);

            JsonMap emailDoc = buildUpdatedEmail(luceneContact);
            JsonMap emailsRes = new JsonMap(BasicContainerFactory.INSTANCE);
            emailsRes.put("prefix", prefixJo);
            emailsRes.put(
                "query",
                new JsonString(EMAILS_QUERY
                    + contact.getLong(CollieFields.CONTACT_ID)));

            JsonList docs = new JsonList(BasicContainerFactory.INSTANCE);
            docs.add(emailDoc);
            emailsRes.put("docs", docs);

            storage.add(
                new UpdateAceVenturaEnvelope(
                    context,
                    emailsRes,
                    1));
        }

        contactRes.put("docs", contactsDocs);

        storage.add(
            new UpdateAceVenturaEnvelope(
                context,
                contactRes,
                contactsDocs.size()));
    }
}
