package ru.yandex.ace.ventura.salo.handlers2.emails;

import java.io.IOException;
import java.util.List;

import ru.yandex.ace.ventura.AceVenturaFields;
import ru.yandex.ace.ventura.salo.AceVenturaIndexContext;
import ru.yandex.ace.ventura.salo.AceVenturaMdbsContext;
import ru.yandex.ace.ventura.salo.ModifyAceVenturaEnvelope;
import ru.yandex.ace.ventura.salo.handlers2.AbstractAceVenturaIndexHandler2;
import ru.yandex.dbfields.CollieFields;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonLong;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.JsonString;
import ru.yandex.json.dom.TypesafeValueContentHandler;
import ru.yandex.json.parser.JsonException;
import ru.yandex.search.salo.Envelope;
import ru.yandex.search.salo.Mdb;
import ru.yandex.search.salo.PingEnvelope;

public class CreateEmailsHandler extends AbstractAceVenturaIndexHandler2 {
    private static final JsonLong DEFAULT_LAST_USAGE = new JsonLong(0L);
    private static final JsonObject PROCESSOR;

    static {
        try {
            String prcStr =
                "{\"pkjoin\":{\"query\":{\"function\":\"concat\","
                    + "\"args\": [\"av_contact_\","
                    + "{\"function\":\"get\", \"args\":[\""
                    + AceVenturaFields.USER_ID.stored()
                    + "\"]}, \"_\","
                    + "{\"function\":\"get\", \"args\":[\""
                    + AceVenturaFields.USER_TYPE.stored()
                    + "\"]}, \"_\","
                    + "{\"function\":\"get\", \"args\":[\""
                    + AceVenturaFields.EMAIL_CID.stored()
                    + "\"]}]},\"get\":[\"" + AceVenturaFields.LIST_ID.stored()
                    + "\",\""
                    + AceVenturaFields.HAS_PHONES.stored() + "\",\""
                    + AceVenturaFields.NAMES.stored() + "\",\""
                    + AceVenturaFields.EN_NAMES.stored() + "\",\""
                    + AceVenturaFields.NAMES_ALIAS.stored() + "\"]}}";
            PROCESSOR = TypesafeValueContentHandler.parse(prcStr);
        } catch (JsonException je) {
            throw new RuntimeException(je);
        }
    }

    public CreateEmailsHandler(final AceVenturaMdbsContext context) {
        super(context);
    }

    @Override
    public void handle(
        final AceVenturaIndexContext context,
        final List<Envelope> storage)
        throws JsonException, IOException
    {
        JsonMap result = new JsonMap(BasicContainerFactory.INSTANCE);
        result.put("prefix", new JsonString(context.prefix().toStringFast()));

        JsonList docsList = fillDocs(context, storage);
        result.put("docs", docsList);
        result.put("processor", PROCESSOR);

        if (docsList.size() == 0) {
            context.logger().warning(
                "All records were skipped "
                    + context.toString());
            storage.add(
                new PingEnvelope(
                    context.changeId(),
                    context.envelopesContext(),
                    (int) (context.prefix().hash() % Mdb.SHARDS)));
        } else {
            storage.add(
                new ModifyAceVenturaEnvelope(context, result, docsList.size()));
        }
    }

    protected JsonList fillDocs(
        final AceVenturaIndexContext context,
        final List<Envelope> storage)
        throws JsonException, IOException
    {
        JsonList docsList = new JsonList(BasicContainerFactory.INSTANCE);

        JsonList emails = context.arguments().getList(CollieFields.EMAILS);
        JsonList emailsIds =
            context.changed().getList(CollieFields.EMAIL_IDS);

        JsonLong revision = new JsonLong(context.revision());
        for (int i = 0; i < emailsIds.size(); i++) {
            JsonMap map = emails.get(i).asMap();
            String email = map.getString(CollieFields.EMAIL);
            Long cid = map.getLong(CollieFields.CONTACT_ID);
            JsonMap luceneEmail =
                buildEmail(
                    context.prefix(),
                    context.prefix(),
                    emailsIds.get(i).asLong(),
                    email);
            if (luceneEmail == null) {
                continue;
            }
            String type = map.getString(CollieFields.TYPE, "");
            String label = map.getString(CollieFields.LABEL, "");

            luceneEmail.put(
                AceVenturaFields.EMAIL_CID.stored(),
                new JsonLong(cid));
            luceneEmail.put(
                AceVenturaFields.EMAIL_LABEL.stored(),
                new JsonString(label));
            luceneEmail.put(
                AceVenturaFields.EMAIL_TYPE.stored(),
                new JsonString(type));
            luceneEmail.put(
                AceVenturaFields.REVISION.stored(),
                revision);
            luceneEmail.put(
                AceVenturaFields.LAST_USAGE.stored(),
                DEFAULT_LAST_USAGE);
            docsList.add(luceneEmail);
        }

        return docsList;
    }
}
