package ru.yandex.ace.ventura.salo.handlers2.emails;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.ace.ventura.AceVenturaFields;
import ru.yandex.ace.ventura.salo.AceVenturaIndexContext;
import ru.yandex.ace.ventura.salo.AceVenturaMdbsContext;
import ru.yandex.ace.ventura.salo.UpdateAceVenturaEnvelope;
import ru.yandex.ace.ventura.salo.handlers2.AbstractAceVenturaIndexHandler2;
import ru.yandex.dbfields.CollieFields;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonLong;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.JsonString;
import ru.yandex.json.parser.JsonException;
import ru.yandex.search.salo.Envelope;
import ru.yandex.search.salo.Mdb;
import ru.yandex.search.salo.PingEnvelope;

public class UpdateEmailsHandler extends AbstractAceVenturaIndexHandler2 {
    public UpdateEmailsHandler(final AceVenturaMdbsContext context) {
        super(context);
    }

    protected JsonList fillDocs(
        final AceVenturaIndexContext context)
        throws JsonException, IOException
    {
        JsonList docsList = new JsonList(BasicContainerFactory.INSTANCE);

        JsonList oldData = context.changed().getList(CollieFields.EMAILS);
        Map<Long, JsonMap> oldDataMap = new LinkedHashMap<>(oldData.size());

        for (JsonObject emailObj: oldData) {
            JsonMap map = emailObj.asMap();
            oldDataMap.put(map.getLong(CollieFields.EMAIL_ID), map);
        }

        JsonLong revision = new JsonLong(context.revision());

        for (JsonObject emailObj: context.arguments().getList(CollieFields.EMAILS)) {
            JsonMap updates = emailObj.asMap();
            long emailId = updates.getLong(CollieFields.EMAIL_ID);

            JsonMap oldEmailMap = oldDataMap.get(emailId);
            if (oldEmailMap == null) {
                throw new IOException("Email not found in changed section " + emailId);
            }
            JsonMap map = merge(oldEmailMap, updates);
            String email = map.getString(CollieFields.EMAIL);

            JsonMap luceneEmail =
                buildEmail(
                    context.prefix(),
                    context.prefix(),
                    emailId,
                    email);

            if (luceneEmail == null) {
                continue;
            }

            luceneEmail.put(
                AceVenturaFields.EMAIL_TYPE.stored(),
                map.get(CollieFields.TYPE));

            luceneEmail.put(
                AceVenturaFields.EMAIL_LABEL.stored(),
                map.get(CollieFields.LABEL));

            luceneEmail.put(
                AceVenturaFields.EMAIL_CID.stored(),
                map.get(CollieFields.CONTACT_ID));

            luceneEmail.put(
                AceVenturaFields.REVISION.stored(),
                revision);

            luceneEmail.put(
                AceVenturaFields.LAST_USAGE.stored(),
                LAST_USAGE_FUNCTION);
            docsList.add(luceneEmail);
        }

        return docsList;
    }

    @Override
    public void handle(
        final AceVenturaIndexContext context,
        final List<Envelope> storage)
        throws JsonException, IOException
    {
        JsonMap result = new JsonMap(BasicContainerFactory.INSTANCE);
        result.put("prefix", new JsonString(context.prefix().toStringFast()));

        JsonList docsList = fillDocs(context);

        result.put("docs", docsList);

        if (docsList.size() == 0) {
            context.logger().warning("All records were skipped");
            storage.add(
                new PingEnvelope(
                    context.changeId(),
                    context.envelopesContext(),
                    (int) (context.prefix().hash() % Mdb.SHARDS)));
        } else {
            storage.add(
                new UpdateAceVenturaEnvelope(context, result, docsList.size()));
        }
    }
}
