package ru.yandex.ace.ventura.salo.handlers2.reindex;

import java.io.IOException;
import java.util.List;

import ru.yandex.ace.ventura.salo.AceVenturaIndexContext;
import ru.yandex.ace.ventura.salo.AceVenturaMdbsContext;
import ru.yandex.ace.ventura.salo.handlers.ReindexContext;
import ru.yandex.ace.ventura.salo.handlers2.AbstractAceVenturaIndexHandler2;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.search.salo.Envelope;

public class ContactsReindexUserHandler
    extends AbstractAceVenturaIndexHandler2
{
    private final boolean keepUsageStats;
    public ContactsReindexUserHandler(
        final AceVenturaMdbsContext context,
        final boolean keepUsageStats)
    {
        super(context);

        this.keepUsageStats = keepUsageStats;
    }

    @Override
    public void handle(
        final AceVenturaIndexContext context,
        final List<Envelope> storage)
        throws IOException, JsonException
    {
        // first delete everything for user
        JsonList lists = context.msalRequest(
            context.prefix(),
            new StringBuilder(AbstractAceVenturaIndexHandler2.GET_LIST_INFO));

        ReindexContext reindexContext = new ReindexContext(context, storage);
        context.logger().info(
            "Reindexing tags " + reindexContext.tagsMap().size());
        reindexTags(reindexContext, reindexContext.tagsMap().values());

        reindexContext.logger().info("Reindexing lists " + lists.size());
        for (JsonObject listObj: lists) {
            reindexList(reindexContext, listObj.asMap(), keepUsageStats);
        }
    }
}
