package ru.yandex.ace.ventura.salo.handlers2.reindex;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpGet;

import ru.yandex.ace.ventura.AceVenturaFields;
import ru.yandex.ace.ventura.AceVenturaPrefix;
import ru.yandex.ace.ventura.AceVenturaRecordType;
import ru.yandex.ace.ventura.UserType;
import ru.yandex.ace.ventura.salo.AceVenturaIndexContext;
import ru.yandex.ace.ventura.salo.AceVenturaMdbProvider;
import ru.yandex.ace.ventura.salo.CollieChangeType;
import ru.yandex.ace.ventura.salo.handlers2.AbstractAceVenturaIndexHandler2;
import ru.yandex.ace.ventura.salo.handlers2.shared.ShareListHandler;
import ru.yandex.dbfields.CollieFields;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonLong;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.JsonString;
import ru.yandex.search.salo.Envelope;
import ru.yandex.search.salo.EnvelopesContext;
import ru.yandex.search.salo.HttpLockHolder;

public class ReindexOrganizationOperation extends ReindexUserOperation {
    private final ShareListHandler shareListHandler;

    public ReindexOrganizationOperation(
        final AceVenturaPrefix prefix,
        final AceVenturaMdbProvider provider,
        final Logger logger)
    {
        super(prefix, provider, logger);

        this.shareListHandler = new ShareListHandler(provider.mdbsContext());
    }

    /**
     * Cleanups shared records from this org for specified user.
     * @param organization
     * @param prefix
     * @param ennvelopesContext
     * @throws Exception
     */
    protected void sendClenaupShared(
            final AceVenturaPrefix organization,
            final AceVenturaPrefix prefix,
            final EnvelopesContext ennvelopesContext)
            throws Exception
    {
        // dropping only share
        StringBuilder uri = new StringBuilder();
        uri.append("/delete?&prefix=");
        uri.append(prefix);
        uri.append("&reindex&cleanup-shared");
        uri.append("&operation-date=");
        uri.append(System.currentTimeMillis());
        uri.append("&text=");
        uri.append(AceVenturaFields.RECORD_TYPE.prefixed());
        uri.append(":");
        uri.append(AceVenturaRecordType.SHARED.fieldValue());
        uri.append("+AND+");
        uri.append(AceVenturaFields.SHARED_OWNER_UID.prefixed());
        uri.append(":");
        uri.append(organization.uid());
        uri.append("+AND+");
        uri.append(AceVenturaFields.SHARED_OWNER_UTYPE.prefixed());
        uri.append(":");
        uri.append(organization.userType().lowName());

        HttpGet request = new HttpGet(uri.toString());
        applyHeaders(request, ennvelopesContext, prefix);
        sendRequest(request);
    }

    @Override
    protected void doAccept(
        final AceVenturaIndexContext indexContext,
        final HttpLockHolder holder,
        final EnvelopesContext envelopesContext)
        throws Exception
    {
        JsonList sharedLists =
            indexContext.msalRequest(
                indexContext.prefix(),
                new StringBuilder(AbstractAceVenturaIndexHandler2.GET_SHARED_LISTS));
        indexContext.logger().info("Fetched sharedList count " + sharedLists.size());

        super.doAccept(indexContext, holder, envelopesContext);
        List<Envelope> storage = new ArrayList<>();

        JsonMap map = new JsonMap(BasicContainerFactory.INSTANCE);
        map.put("change_type", new JsonString(CollieChangeType.REINDEX_USER.lowName()));
        map.put(CollieFields.USER_TYPE, new JsonString(prefix.userType().lowName()));
        map.put(CollieFields.USER_ID, new JsonLong(prefix.uid()));
        map.put(CollieFields.OPERATION_ID, new JsonLong(-1L));
        map.put(CollieFields.OPERATION_DATE, new JsonLong(System.currentTimeMillis()));
        map.put(CollieFields.SELECT_DATE, new JsonLong(System.currentTimeMillis()));
        map.put("changed", new JsonMap(BasicContainerFactory.INSTANCE));

        for (JsonObject list: sharedLists) {
            map.put(CollieFields.REVISION, list.get(CollieFields.REVISION));
            map.put("arguments", list);

            AceVenturaIndexContext listIndexContext =
                new AceVenturaIndexContext(provider.mdbsContext(), envelopesContext, logger, map);

            long sharedToUserId =
                listIndexContext.arguments().getLong(CollieFields.SHARED_TO_USER_UID);
            UserType sharedToUserType =
                listIndexContext.arguments().getEnum(
                    UserType.class,
                    CollieFields.SHARED_TO_USER_TYPE);

            AceVenturaPrefix client = new AceVenturaPrefix(sharedToUserId, sharedToUserType);

            shareListHandler.handle(listIndexContext, storage);
            sendClenaupShared(indexContext.prefix(), client, envelopesContext);

            if (storage.size() >= salo.config().requestsBatchSize()) {
                HttpRequest indexRequest =
                    holder.makeSetRequest(storage, "reindex-worker", false);
                sendRequest(indexRequest);
                storage.clear();
            }
        }

        if (storage.size() > 0) {
            HttpRequest indexRequest =
                holder.makeSetRequest(storage, "reindex-worker", false);
            sendRequest(indexRequest);
            storage.clear();
        }
    }
}
