package ru.yandex.ace.ventura.salo.handlers2.shared;

import java.io.IOException;
import java.util.List;

import ru.yandex.ace.ventura.AceVenturaFields;
import ru.yandex.ace.ventura.AceVenturaPrefix;
import ru.yandex.ace.ventura.AceVenturaRecordType;
import ru.yandex.ace.ventura.UserType;
import ru.yandex.ace.ventura.salo.AceVenturaIndexContext;
import ru.yandex.ace.ventura.salo.AceVenturaMdbsContext;
import ru.yandex.ace.ventura.salo.ModifyAceVenturaEnvelope;
import ru.yandex.ace.ventura.salo.handlers2.AbstractAceVenturaIndexHandler2;
import ru.yandex.dbfields.CollieFields;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonLong;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonString;
import ru.yandex.json.parser.JsonException;
import ru.yandex.search.salo.Envelope;

public class ShareListHandler extends AbstractAceVenturaIndexHandler2 {
    public ShareListHandler(final AceVenturaMdbsContext context) {
        super(context);
    }

    @Override
    public void handle(
        final AceVenturaIndexContext context,
        final List<Envelope> storage)
        throws JsonException, IOException
    {
        JsonMap result = new JsonMap(BasicContainerFactory.INSTANCE);
        result.put("prefix", new JsonString(context.prefix().toStringFast()));

        Long listId = context.arguments().getLong(CollieFields.LIST_ID);
        Long sharedToUserId =
            context.arguments().getLong(CollieFields.SHARED_TO_USER_UID);
        UserType sharedToUserType =
            context.arguments().getEnum(
                UserType.class,
                CollieFields.SHARED_TO_USER_TYPE);

        AceVenturaPrefix sharedTo =
            new AceVenturaPrefix(sharedToUserId, sharedToUserType);

        JsonList docs = new JsonList(BasicContainerFactory.INSTANCE);
        JsonMap doc = new JsonMap(BasicContainerFactory.INSTANCE);

        doc.put(AceVenturaFields.ID.stored(),
            new JsonString(AceVenturaFields.sharedUrl(
                listId.toString(),
                context.prefix(),
                sharedTo)));
        doc.put(
            AceVenturaFields.SHARED_OWNER_UID.stored(),
            new JsonLong(context.prefix().uid()));
        doc.put(
            AceVenturaFields.SHARED_OWNER_UTYPE.stored(),
            new JsonString(context.prefix().userType().lowName()));
        doc.put(
            AceVenturaFields.RECORD_TYPE.stored(),
            new JsonString(AceVenturaRecordType.SHARED.fieldValue()));
        doc.put(
            AceVenturaFields.SHARED_LIST_ID.stored(),
            new JsonLong(listId));
        docs.add(doc);

        result.put("prefix", new JsonString(sharedTo.toStringFast()));
        result.put("docs", docs);

        storage.add(
            new ModifyAceVenturaEnvelope(
                context,
                sharedTo,
                result,
                docs.size()));
    }
}
