package ru.yandex.ace.ventura.salo.handlers2.tags;

import java.io.IOException;
import java.util.List;

import ru.yandex.ace.ventura.salo.AceVenturaIndexContext;
import ru.yandex.ace.ventura.salo.AceVenturaMdbsContext;
import ru.yandex.ace.ventura.salo.TagInfo;
import ru.yandex.ace.ventura.salo.UpdateAceVenturaEnvelope;
import ru.yandex.ace.ventura.salo.handlers2.AbstractAceVenturaIndexHandler2;
import ru.yandex.dbfields.CollieFields;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonBoolean;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonString;
import ru.yandex.json.parser.JsonException;
import ru.yandex.search.salo.Envelope;

public class CreateTagHandler extends AbstractAceVenturaIndexHandler2 {
    public CreateTagHandler(final AceVenturaMdbsContext context) {
        super(context);
    }

    @Override
    public void handle(
        final AceVenturaIndexContext context,
        final List<Envelope> storage)
        throws IOException, JsonException
    {
        Long tagId = context.changed().getLong(CollieFields.TAG_ID);
        String name = context.arguments().getString("name");
        String type = context.arguments().getString("type");
        TagInfo tagInfo = new TagInfo(tagId, name, type, context.revision());
        JsonMap luceneDoc = buildTag(context.prefix(), tagInfo);

        JsonMap result = new JsonMap(BasicContainerFactory.INSTANCE);
        result.put(
            "prefix",
            new JsonString(context.prefix().toStringFast()));
        result.put("AddIfNotExists", JsonBoolean.TRUE);
        JsonList list = new JsonList(BasicContainerFactory.INSTANCE);
        list.add(luceneDoc);
        result.put("docs", list);

        storage.add(new UpdateAceVenturaEnvelope(context, result, list.size()));
    }
}
