package ru.yandex.ace.ventura.salo.handlers2.tags;

import java.io.IOException;
import java.util.List;

import ru.yandex.ace.ventura.AceVenturaFields;
import ru.yandex.ace.ventura.salo.AceVenturaIndexContext;
import ru.yandex.ace.ventura.salo.AceVenturaMdbsContext;
import ru.yandex.ace.ventura.salo.DeleteAceVenturaEnvelope;
import ru.yandex.ace.ventura.salo.handlers2.AbstractAceVenturaIndexHandler2;
import ru.yandex.dbfields.CollieFields;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonString;
import ru.yandex.json.parser.JsonException;
import ru.yandex.search.salo.Envelope;

public class DeleteTagHandler extends AbstractAceVenturaIndexHandler2 {
    public DeleteTagHandler(final AceVenturaMdbsContext context) {
        super(context);
    }

    @Override
    public void handle(
        final AceVenturaIndexContext context,
        final List<Envelope> storage)
        throws IOException, JsonException
    {
        Long tagId = context.arguments().getLong(CollieFields.TAG_ID);

        JsonMap luceneDoc = new JsonMap(BasicContainerFactory.INSTANCE);
        luceneDoc.put(
            AceVenturaFields.ID.stored(),
            new JsonString(AceVenturaFields.tagUrl(
                tagId.toString(),
                context.prefix())));

        JsonMap result = new JsonMap(BasicContainerFactory.INSTANCE);
        result.put(
            "prefix",
            new JsonString(context.prefix().toStringFast()));
        JsonList list = new JsonList(BasicContainerFactory.INSTANCE);
        list.add(luceneDoc);
        result.put("docs", list);

        storage.add(
            new DeleteAceVenturaEnvelope(context, result, list.size()));
    }
}
