package ru.yandex.ace.ventura.salo.handlers2.tags;

import java.io.IOException;
import java.util.List;
import java.util.function.BiFunction;

import ru.yandex.ace.ventura.AceVenturaFields;
import ru.yandex.ace.ventura.AceVenturaRecordType;
import ru.yandex.ace.ventura.salo.AceVenturaIndexContext;
import ru.yandex.ace.ventura.salo.AceVenturaMdbsContext;
import ru.yandex.ace.ventura.salo.UpdateAceVenturaEnvelope;
import ru.yandex.ace.ventura.salo.handlers2.AbstractAceVenturaIndexHandler2;
import ru.yandex.ace.ventura.salo.handlers2.AceVenturaHandlerUtils;
import ru.yandex.dbfields.CollieFields;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonLong;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.JsonString;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.search.salo.Envelope;

public class TagContactsHandler extends AbstractAceVenturaIndexHandler2 {
    private static final BiFunction<JsonObject, JsonMap, JsonMap> ADD_TAG =
        AceVenturaHandlerUtils.INSTANCE.makeSet(AceVenturaFields.TAGS.stored());
    private static final BiFunction<JsonObject, JsonMap, JsonMap> ADD_CTAG =
        AceVenturaHandlerUtils.INSTANCE.makeSet(AceVenturaFields.CONTACT_TAGS.stored());

    protected static final String EMAILS_QUERY =
        AceVenturaFields.RECORD_TYPE.prefixed()
            + ':'
            + AceVenturaRecordType.EMAIL.fieldValue()
            + " AND "
            + AceVenturaFields.EMAIL_CID.prefixed()
            + ':';

    public TagContactsHandler(final AceVenturaMdbsContext context) {
        super(context);
    }

    @Override
    public void handle(
        final AceVenturaIndexContext context,
        final List<Envelope> storage)
        throws IOException, JsonException
    {
        JsonMap result = new JsonMap(BasicContainerFactory.INSTANCE);
        JsonObject prefixJo = new JsonString(context.prefix().toStringFast());
        result.put("prefix", prefixJo);
        JsonList docsList = new JsonList(BasicContainerFactory.INSTANCE);

        JsonMap args = context.arguments();
        Long tagId  = args.getLong(CollieFields.TAG_ID);
        JsonList contactsIds = args.getList(CollieFields.CONTACT_IDS);
        if (contactsIds.size() == 0) {
            context.logger().warning(
                "TagContacts empty list of concacts ids "
                + context.toString());
            return;
        }

        for (JsonObject jo: contactsIds) {
            String contactId = jo.asString();
            String aceContactId = AceVenturaFields.contactUrl(
                contactId,
                context.prefix(),
                context.prefix());

            JsonMap doc = new JsonMap(BasicContainerFactory.INSTANCE);
            doc.put(AceVenturaFields.ID.stored(), new JsonString(aceContactId));
            ADD_TAG.apply(new JsonLong(tagId), doc);
            ADD_CTAG.apply(new JsonLong(tagId), doc);
            doc.put(
                AceVenturaFields.REVISION.stored(),
                new JsonLong(context.revision()));
            docsList.add(doc);

            // updating av_record_type: email records
            JsonMap emailDoc = new JsonMap(BasicContainerFactory.INSTANCE);
            ADD_CTAG.apply(new JsonLong(tagId), emailDoc);

            JsonMap emailsRes = new JsonMap(BasicContainerFactory.INSTANCE);
            emailsRes.put("prefix", prefixJo);
            emailsRes.put(
                "query",
                new JsonString(EMAILS_QUERY + contactId));

            JsonList docs = new JsonList(BasicContainerFactory.INSTANCE);
            docs.add(emailDoc);
            emailsRes.put("docs", docs);

            storage.add(
                new UpdateAceVenturaEnvelope(
                    context,
                    emailsRes,
                    1));
            context.logger().info("TagContactsEmails" + JsonType.NORMAL.toString(emailsRes));
        }

        result.put("docs", docsList);
        context.logger().info("TagContacts " + JsonType.NORMAL.toString(result));
        storage.add(
            new UpdateAceVenturaEnvelope(
                context,
                result,
                docsList.size()));

        // update contact_tags in emails
    }
}
