package ru.yandex.ace.ventura.salo.handlers2.tags;

import java.io.IOException;
import java.util.List;
import java.util.function.BiFunction;

import ru.yandex.ace.ventura.AceVenturaFields;
import ru.yandex.ace.ventura.salo.AceVenturaIndexContext;
import ru.yandex.ace.ventura.salo.AceVenturaMdbsContext;
import ru.yandex.ace.ventura.salo.UpdateAceVenturaEnvelope;
import ru.yandex.ace.ventura.salo.handlers2.AbstractAceVenturaIndexHandler2;
import ru.yandex.ace.ventura.salo.handlers2.AceVenturaHandlerUtils;
import ru.yandex.dbfields.CollieFields;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonLong;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.JsonString;
import ru.yandex.json.parser.JsonException;
import ru.yandex.search.salo.Envelope;

public class TagEmailsHandler extends AbstractAceVenturaIndexHandler2 {
    private static final BiFunction<JsonObject, JsonMap, JsonMap> ADD_TAG =
        AceVenturaHandlerUtils.INSTANCE.makeSet(AceVenturaFields.TAGS.stored());
    private static final BiFunction<JsonObject, JsonMap, JsonMap> ADD_ETAG =
        AceVenturaHandlerUtils.INSTANCE.makeSet(AceVenturaFields.EMAIL_TAGS.stored());

    public TagEmailsHandler(final AceVenturaMdbsContext context) {
        super(context);
    }

    @Override
    public void handle(
        final AceVenturaIndexContext context,
        final List<Envelope> storage)
        throws IOException, JsonException
    {
        JsonMap result = new JsonMap(BasicContainerFactory.INSTANCE);
        result.put("prefix", new JsonString(context.prefix().toStringFast()));
        JsonList docsList = new JsonList(BasicContainerFactory.INSTANCE);

        JsonMap args = context.arguments();
        Long tagId = args.getLong(CollieFields.TAG_ID);
        JsonList emailsIds = args.getList(CollieFields.EMAIL_IDS);
        if (emailsIds.size() == 0) {
            context.logger().warning(
                "TagEmails empty list of emails ids "
                    + context.toString());
            return;
        }

        for (JsonObject jo: emailsIds) {
            String emailId = jo.asString();
            String aceEmailId = AceVenturaFields.emailUrl(
                emailId,
                context.prefix(),
                context.prefix());

            JsonMap doc = new JsonMap(BasicContainerFactory.INSTANCE);
            doc.put(AceVenturaFields.ID.field(), new JsonString(aceEmailId));
            ADD_TAG.apply(new JsonLong(tagId), doc);
            ADD_ETAG.apply(new JsonLong(tagId), doc);
            doc.put(
                AceVenturaFields.REVISION.field(),
                new JsonLong(context.revision()));
            docsList.add(doc);
        }

        result.put("docs", docsList);

        storage.add(
            new UpdateAceVenturaEnvelope(
                context,
                result,
                docsList.size()));
    }
}
