package ru.yandex.ace.ventura.salo.handlers2.tags;

import java.io.IOException;
import java.util.List;
import java.util.function.BiFunction;

import ru.yandex.ace.ventura.AceVenturaFields;
import ru.yandex.ace.ventura.salo.AceVenturaIndexContext;
import ru.yandex.ace.ventura.salo.AceVenturaMdbsContext;
import ru.yandex.ace.ventura.salo.UpdateAceVenturaEnvelope;
import ru.yandex.ace.ventura.salo.handlers2.AbstractAceVenturaIndexHandler2;
import ru.yandex.ace.ventura.salo.handlers2.AceVenturaHandlerUtils;
import ru.yandex.dbfields.CollieFields;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonLong;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.JsonString;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.search.salo.Envelope;
import ru.yandex.search.salo.Mdb;
import ru.yandex.search.salo.PingEnvelope;

public class UnTagContactsHandler extends AbstractAceVenturaIndexHandler2 {
    private static final BiFunction<JsonObject, JsonMap, JsonMap> DEL_TAG =
        AceVenturaHandlerUtils.INSTANCE.removeSet(
            AceVenturaFields.TAGS.stored());
    private static final BiFunction<JsonObject, JsonMap, JsonMap> DEL_CTAG =
        AceVenturaHandlerUtils.INSTANCE.removeSet(
            AceVenturaFields.CONTACT_TAGS.stored());

    public UnTagContactsHandler(final AceVenturaMdbsContext context) {
        super(context);
    }

    @Override
    public void handle(
        final AceVenturaIndexContext context,
        final List<Envelope> storage)
        throws IOException, JsonException
    {
        JsonObject prefixJo = new JsonString(context.prefix().toStringFast());

        JsonMap result = new JsonMap(BasicContainerFactory.INSTANCE);
        result.put("prefix", prefixJo);
        JsonList docsList = new JsonList(BasicContainerFactory.INSTANCE);

        JsonMap args = context.arguments();
        Long tagId  = args.getLong(CollieFields.TAG_ID, null);
        if (tagId == null) {
            context.logger().warning(
                "Tag id null, looks like delete for contact, skipping record");
            return;
        }

        JsonList contactsIds = args.getList(CollieFields.CONTACT_IDS);
        if (contactsIds.size() == 0) {
            context.logger().warning(
                "TagContacts empty list of concacts ids "
                    + context.toString());
            storage.add(
                new PingEnvelope(
                    context.changeId(),
                    context.envelopesContext(),
                    (int) (context.prefix().hash() % Mdb.SHARDS)));
            return;
        }

        for (JsonObject jo: contactsIds) {
            String contactId = jo.asString();
            String aceContactId = AceVenturaFields.contactUrl(
                contactId,
                context.prefix(),
                context.prefix());

            JsonMap doc = new JsonMap(BasicContainerFactory.INSTANCE);
            doc.put(AceVenturaFields.ID.field(), new JsonString(aceContactId));
            JsonLong tagIdObj = new JsonLong(tagId);
            DEL_TAG.apply(tagIdObj, doc);
            DEL_CTAG.apply(tagIdObj, doc);
            doc.put(
                AceVenturaFields.REVISION.field(),
                new JsonLong(context.revision()));
            docsList.add(doc);

            // updating av_record_type: email records
            JsonMap emailDoc = new JsonMap(BasicContainerFactory.INSTANCE);
            DEL_CTAG.apply(tagIdObj, emailDoc);

            JsonMap emailsRes = new JsonMap(BasicContainerFactory.INSTANCE);
            emailsRes.put("prefix", prefixJo);
            emailsRes.put(
                "query",
                new JsonString(TagContactsHandler.EMAILS_QUERY + contactId));

            JsonList docs = new JsonList(BasicContainerFactory.INSTANCE);
            docs.add(emailDoc);
            emailsRes.put("docs", docs);

            storage.add(
                new UpdateAceVenturaEnvelope(
                    context,
                    emailsRes,
                    1));
            context.logger().info("UntagContactEmail " + JsonType.NORMAL.toString(emailsRes));
        }

        result.put("docs", docsList);

        context.logger().info("UntagContact" + JsonType.NORMAL.toString(docsList));
        storage.add(
            new UpdateAceVenturaEnvelope(
                context,
                result,
                docsList.size()));
    }
}
